/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import io.thekraken.grok.api.BooleanConverter;
import io.thekraken.grok.api.ByteConverter;
import io.thekraken.grok.api.DateConverter;
import io.thekraken.grok.api.DoubleConverter;
import io.thekraken.grok.api.FloatConverter;
import io.thekraken.grok.api.IConverter;
import io.thekraken.grok.api.IntegerConverter;
import io.thekraken.grok.api.KeyValue;
import io.thekraken.grok.api.LongConverter;
import io.thekraken.grok.api.ShortConverter;
import io.thekraken.grok.api.StringConverter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Converter {
    public static Map<String, IConverter<?>> converters = new HashMap();
    public static Locale locale = Locale.ENGLISH;

    private static IConverter getConverter(String key) throws Exception {
        IConverter<?> converter = converters.get(key);
        if (converter == null) {
            throw new Exception("Invalid data type :" + key);
        }
        return converter;
    }

    public static KeyValue convert(String key, Object value) {
        String[] spec = key.split(";|:", 3);
        try {
            if (spec.length == 1) {
                return new KeyValue(spec[0], value);
            }
            if (spec.length == 2) {
                return new KeyValue(spec[0], Converter.getConverter(spec[1]).convert(String.valueOf(value)));
            }
            if (spec.length == 3) {
                return new KeyValue(spec[0], Converter.getConverter(spec[1]).convert(String.valueOf(value), spec[2]));
            }
            return new KeyValue(spec[0], value, "Unsupported spec :" + key);
        }
        catch (Exception e) {
            return new KeyValue(spec[0], value, e.toString());
        }
    }

    static {
        converters.put("byte", new ByteConverter());
        converters.put("boolean", new BooleanConverter());
        converters.put("short", new ShortConverter());
        converters.put("int", new IntegerConverter());
        converters.put("long", new LongConverter());
        converters.put("float", new FloatConverter());
        converters.put("double", new DoubleConverter());
        converters.put("date", new DateConverter());
        converters.put("datetime", new DateConverter());
        converters.put("string", new StringConverter());
    }
}

