/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import io.thekraken.grok.api.Discovery;
import io.thekraken.grok.api.GrokUtils;
import io.thekraken.grok.api.Match;
import io.thekraken.grok.api.exception.GrokException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grok
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Grok.class);
    private String namedRegex = "";
    private Map<String, String> namedRegexCollection;
    private String originalGrokPattern = "";
    private Pattern compiledNamedRegex = null;
    private Discovery disco = null;
    private Map<String, String> grokPatternDefinition = new TreeMap<String, String>();
    private String savedPattern = "";
    public static final Grok EMPTY = new Grok();

    public Grok() {
        this.namedRegexCollection = new TreeMap<String, String>();
    }

    public String getSaved_pattern() {
        return this.savedPattern;
    }

    public void setSaved_pattern(String savedpattern) {
        this.savedPattern = savedpattern;
    }

    public static Grok create(String grokPatternPath, String grokExpression) throws GrokException {
        if (StringUtils.isBlank((CharSequence)grokPatternPath)) {
            throw new GrokException("{grokPatternPath} should not be empty or null");
        }
        Grok g = new Grok();
        g.addPatternFromFile(grokPatternPath);
        if (StringUtils.isNotBlank((CharSequence)grokExpression)) {
            g.compile(grokExpression, false);
        }
        return g;
    }

    public static Grok create(String grokPatternPath) throws GrokException {
        return Grok.create(grokPatternPath, null);
    }

    public void addPattern(String name, String pattern) throws GrokException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new GrokException("Invalid Pattern name");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new GrokException("Invalid Pattern");
        }
        this.grokPatternDefinition.put(name, pattern);
    }

    public void copyPatterns(Map<String, String> cpy) throws GrokException {
        if (cpy == null) {
            throw new GrokException("Invalid Patterns");
        }
        if (cpy.isEmpty()) {
            throw new GrokException("Invalid Patterns");
        }
        for (Map.Entry<String, String> entry : cpy.entrySet()) {
            this.grokPatternDefinition.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public Map<String, String> getPatterns() {
        return this.grokPatternDefinition;
    }

    public String getNamedRegex() {
        return this.namedRegex;
    }

    public void addPatternFromFile(String file) throws GrokException {
        File f = new File(file);
        if (!f.exists()) {
            throw new GrokException("Pattern not found");
        }
        if (!f.canRead()) {
            throw new GrokException("Pattern cannot be read");
        }
        FileReader r = null;
        try {
            r = new FileReader(f);
            this.addPatternFromReader(r);
        }
        catch (FileNotFoundException e) {
            throw new GrokException(e.getMessage());
        }
        catch (IOException e) {
            throw new GrokException(e.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void addPatternFromReader(Reader r) throws GrokException {
        BufferedReader br = new BufferedReader(r);
        Pattern pattern = Pattern.compile("^([A-z0-9_]+)\\s+(.*)$");
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line);
                if (!m.matches()) continue;
                this.addPattern(m.group(1), m.group(2));
            }
            br.close();
        }
        catch (IOException e) {
            throw new GrokException(e.getMessage());
        }
        catch (GrokException e) {
            throw new GrokException(e.getMessage());
        }
    }

    public String capture(String log) {
        Match match = this.match(log);
        match.captures();
        return match.toJson();
    }

    public List<String> captures(List<String> logs) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String log : logs) {
            Match match = this.match(log);
            match.captures();
            matched.add(match.toJson());
        }
        return matched;
    }

    public Match match(String text) {
        if (this.compiledNamedRegex == null || StringUtils.isBlank((CharSequence)text)) {
            return Match.EMPTY;
        }
        Matcher m = this.compiledNamedRegex.matcher(text);
        Match match = new Match();
        if (m.find()) {
            match.setSubject(text);
            match.setGrok(this);
            match.setMatch(m);
            match.setStart(m.start(0));
            match.setEnd(m.end(0));
        }
        return match;
    }

    public void compile(String pattern) throws GrokException {
        this.compile(pattern, false);
    }

    public void compile(String pattern, boolean namedOnly) throws GrokException {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new GrokException("{pattern} should not be empty or null");
        }
        this.namedRegex = pattern;
        this.originalGrokPattern = pattern;
        int index = 0;
        int iterationLeft = 1000;
        Boolean continueIteration = true;
        while (continueIteration.booleanValue()) {
            continueIteration = false;
            if (iterationLeft <= 0) {
                throw new GrokException("Deep recursion pattern compilation of " + this.originalGrokPattern);
            }
            --iterationLeft;
            Matcher m = GrokUtils.GROK_PATTERN.matcher(this.namedRegex);
            if (!m.find()) continue;
            continueIteration = true;
            Map<String, String> group = GrokUtils.namedGroups(m, m.group());
            if (group.get("definition") != null) {
                try {
                    this.addPattern(group.get("pattern"), group.get("definition"));
                    group.put("name", group.get("name") + "=" + group.get("definition"));
                }
                catch (GrokException grokException) {
                    // empty catch block
                }
            }
            int count = StringUtils.countMatches((CharSequence)this.namedRegex, (CharSequence)("%{" + group.get("name") + "}"));
            for (int i = 0; i < count; ++i) {
                String replacement = String.format("(?<name%d>%s)", index, this.grokPatternDefinition.get(group.get("pattern")));
                if (namedOnly && group.get("subname") == null) {
                    replacement = this.grokPatternDefinition.get(group.get("pattern"));
                }
                this.namedRegexCollection.put("name" + index, group.get("subname") != null ? group.get("subname") : group.get("name"));
                this.namedRegex = StringUtils.replace((String)this.namedRegex, (String)("%{" + group.get("name") + "}"), (String)replacement, (int)1);
                ++index;
            }
        }
        if (this.namedRegex.isEmpty()) {
            throw new GrokException("Pattern not fount");
        }
        this.compiledNamedRegex = Pattern.compile(this.namedRegex);
    }

    public String discover(String input) {
        if (this.disco == null) {
            this.disco = new Discovery(this);
        }
        return this.disco.discover(input);
    }

    public String getOriginalGrokPattern() {
        return this.originalGrokPattern;
    }

    public String getNamedRegexCollectionById(String id) {
        return this.namedRegexCollection.get(id);
    }

    public Map<String, String> getNamedRegexCollection() {
        return this.namedRegexCollection;
    }
}

