/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.thekraken.grok.api.Converter;
import io.thekraken.grok.api.Garbage;
import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.GrokUtils;
import io.thekraken.grok.api.KeyValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;

public class Match {
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Gson GSON = new GsonBuilder().create();
    private String subject = "Nothing";
    private Map<String, Object> capture = new TreeMap<String, Object>();
    private Garbage garbage = new Garbage();
    private Grok grok = null;
    private Matcher match = null;
    private int start = 0;
    private int end = 0;
    private static ThreadLocal<Match> matchHolder = new ThreadLocal<Match>(){

        @Override
        protected Match initialValue() {
            return new Match();
        }
    };
    public static final Match EMPTY = new Match();

    public void setGrok(Grok grok) {
        if (grok != null) {
            this.grok = grok;
        }
    }

    public Matcher getMatch() {
        return this.match;
    }

    public void setMatch(Matcher match) {
        this.match = match;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public static Match getInstance() {
        return matchHolder.get();
    }

    public void setSubject(String text) {
        if (text == null) {
            return;
        }
        if (text.isEmpty()) {
            return;
        }
        this.subject = text;
    }

    public String getSubject() {
        return this.subject;
    }

    public void captures() {
        if (this.match == null) {
            return;
        }
        this.capture.clear();
        Map<String, String> mappedw = GrokUtils.namedGroups(this.match, this.subject);
        Iterator<Map.Entry<String, String>> it = mappedw.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pairs = it.next();
            String key = null;
            Object value = null;
            if (this.grok.getNamedRegexCollectionById(pairs.getKey().toString()) == null) {
                key = pairs.getKey().toString();
            } else if (!this.grok.getNamedRegexCollectionById(pairs.getKey().toString()).isEmpty()) {
                key = this.grok.getNamedRegexCollectionById(pairs.getKey().toString());
            }
            if (pairs.getValue() != null) {
                value = pairs.getValue().toString();
                KeyValue keyValue = Converter.convert(key, value);
                key = keyValue.getKey();
                value = keyValue.getValue() instanceof String ? this.cleanString((String)keyValue.getValue()) : keyValue.getValue();
                if (keyValue.hasGrokFailure()) {
                    this.capture.put(key + "_grokfailure", keyValue.getGrokFailure());
                }
            }
            if (this.capture.containsKey(key)) {
                Object currentValue = this.capture.get(key);
                if (currentValue instanceof List) {
                    ((List)currentValue).add(value);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(currentValue);
                    list.add(value);
                    this.capture.put(key, list);
                }
            } else {
                this.capture.put(key, value);
            }
            it.remove();
        }
    }

    private String cleanString(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        char[] tmp = value.toCharArray();
        if (tmp.length == 1 && (tmp[0] == '\"' || tmp[0] == '\'')) {
            value = "";
        } else if (tmp[0] == '\"' && tmp[value.length() - 1] == '\"' || tmp[0] == '\'' && tmp[value.length() - 1] == '\'') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public String toJson(Boolean pretty) {
        if (this.capture == null) {
            return "{}";
        }
        if (this.capture.isEmpty()) {
            return "{}";
        }
        this.cleanMap();
        Gson gs = pretty != false ? PRETTY_GSON : GSON;
        return gs.toJson(this.capture);
    }

    public String toJson() {
        return this.toJson(false);
    }

    public Map<String, Object> toMap() {
        this.cleanMap();
        return this.capture;
    }

    private void cleanMap() {
        this.garbage.rename(this.capture);
        this.garbage.remove(this.capture);
    }

    public Boolean isNull() {
        return this.match == null;
    }
}

