/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.autoconfigure.models.ollama;

import io.micrometer.observation.ObservationRegistry;
import io.thomasvitale.langchain4j.autoconfigure.models.ollama.OllamaChatProperties;
import io.thomasvitale.langchain4j.autoconfigure.models.ollama.OllamaConnectionDetails;
import io.thomasvitale.langchain4j.autoconfigure.models.ollama.OllamaEmbeddingProperties;
import io.thomasvitale.langchain4j.autoconfigure.models.ollama.OllamaProperties;
import io.thomasvitale.langchain4j.spring.ollama.OllamaChatModel;
import io.thomasvitale.langchain4j.spring.ollama.OllamaEmbeddingModel;
import io.thomasvitale.langchain4j.spring.ollama.client.OllamaClient;
import io.thomasvitale.langchain4j.spring.ollama.client.OllamaClientConfig;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={OllamaChatModel.class})
@ConditionalOnProperty(prefix="langchain4j.ollama", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={OllamaProperties.class, OllamaChatProperties.class, OllamaEmbeddingProperties.class})
public class OllamaAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OllamaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={OllamaConnectionDetails.class})
    PropertiesOllamaConnectionDetails propertiesOllamaConnectionDetails(OllamaProperties ollamaProperties) {
        return new PropertiesOllamaConnectionDetails(ollamaProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={OllamaClient.class})
    OllamaClient ollamaClient(OllamaConnectionDetails ollamaConnectionDetails, OllamaProperties ollamaProperties, RestClient.Builder restClientBuilder) {
        OllamaClientConfig ollamaClientConfig = OllamaClientConfig.builder().baseUrl(ollamaConnectionDetails.getUrl()).connectTimeout(ollamaProperties.getClient().getConnectTimeout()).readTimeout(ollamaProperties.getClient().getReadTimeout()).sslBundle(ollamaProperties.getClient().getSslBundle()).logRequests(ollamaProperties.getClient().isLogRequests()).logResponses(ollamaProperties.getClient().isLogResponses()).build();
        if (ollamaProperties.getClient().isLogRequests()) {
            logger.warn("You have enabled logging of the request body sent to the model, with the risk of exposing sensitive or private information. Please, be careful!");
        }
        if (ollamaProperties.getClient().isLogResponses()) {
            logger.warn("You have enabled logging of the response body from a model, with the risk of exposing sensitive or private information. Please, be careful!");
        }
        return new OllamaClient(ollamaClientConfig, restClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    OllamaChatModel ollamaChatModel(OllamaClient ollamaClient, OllamaChatProperties ollamaChatProperties, ObjectProvider<ObservationRegistry> observationRegistry) {
        return OllamaChatModel.builder().client(ollamaClient).model(ollamaChatProperties.getModel()).format(ollamaChatProperties.getFormat()).options(ollamaChatProperties.getOptions()).observationRegistry(Objects.requireNonNullElse((ObservationRegistry)observationRegistry.getIfUnique(), ObservationRegistry.NOOP)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    OllamaEmbeddingModel ollamaEmbeddingModel(OllamaClient ollamaClient, OllamaEmbeddingProperties ollamaEmbeddingProperties, ObjectProvider<ObservationRegistry> observationRegistry) {
        return OllamaEmbeddingModel.builder().client(ollamaClient).model(ollamaEmbeddingProperties.getModel()).options(ollamaEmbeddingProperties.getOptions()).observationRegistry(Objects.requireNonNullElse((ObservationRegistry)observationRegistry.getIfUnique(), ObservationRegistry.NOOP)).build();
    }

    static class PropertiesOllamaConnectionDetails
    implements OllamaConnectionDetails {
        private final OllamaProperties ollamaProperties;

        PropertiesOllamaConnectionDetails(OllamaProperties ollamaProperties) {
            this.ollamaProperties = ollamaProperties;
        }

        @Override
        public URI getUrl() {
            return this.ollamaProperties.getClient().getBaseUrl();
        }
    }
}

