/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.autoconfigure.observation;

import io.thomasvitale.langchain4j.autoconfigure.observation.ObservationsProperties;
import io.thomasvitale.langchain4j.spring.core.chat.observation.ChatPromptObservationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={ObservationsProperties.class})
public class ObservationsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ObservationsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="langchain4j.observations", name={"include-prompt-messages"}, havingValue="true", matchIfMissing=false)
    ChatPromptObservationFilter chatPromptObservationFilter() {
        logger.warn("You have enabled the inclusion of the prompt body in the observations, with the risk of exposing sensitive or private information. Please, be careful!");
        return new ChatPromptObservationFilter();
    }
}

