/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.autoconfigure.vectorstores.weaviate;

import io.thomasvitale.langchain4j.autoconfigure.vectorstores.weaviate.WeaviateConnectionDetails;
import io.thomasvitale.langchain4j.autoconfigure.vectorstores.weaviate.WeaviateProperties;
import io.thomasvitale.langchain4j.spring.weaviate.WeaviateEmbeddingStore;
import io.thomasvitale.langchain4j.spring.weaviate.client.WeaviateClientConfig;
import java.net.URI;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={WeaviateEmbeddingStore.class})
@ConditionalOnProperty(prefix="langchain4j.vectorstore.weaviate", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WeaviateProperties.class})
public class WeaviateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WeaviateConnectionDetails.class})
    PropertiesWeaviateConnectionDetails propertiesWeaviateConnectionDetails(WeaviateProperties weaviateProperties) {
        return new PropertiesWeaviateConnectionDetails(weaviateProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    WeaviateEmbeddingStore weaviateEmbeddingStore(WeaviateConnectionDetails weaviateConnectionDetails, WeaviateProperties weaviateProperties) {
        WeaviateClientConfig clientConfig = WeaviateClientConfig.builder().url(weaviateConnectionDetails.getUrl()).connectTimeout(weaviateProperties.getClient().getConnectTimeout()).readTimeout(weaviateProperties.getClient().getReadTimeout()).sslBundle(weaviateProperties.getClient().getSslBundle()).apiKey(weaviateConnectionDetails.getApiKey()).headers(weaviateProperties.getClient().getHeaders()).build();
        return WeaviateEmbeddingStore.builder().clientConfig(clientConfig).objectClassName(weaviateProperties.getObjectClassName()).consistencyLevel(weaviateProperties.getConsistencyLevel()).build();
    }

    static class PropertiesWeaviateConnectionDetails
    implements WeaviateConnectionDetails {
        private final WeaviateProperties weaviateProperties;

        PropertiesWeaviateConnectionDetails(WeaviateProperties weaviateProperties) {
            this.weaviateProperties = weaviateProperties;
        }

        @Override
        public URI getUrl() {
            return this.weaviateProperties.getClient().getUrl();
        }

        @Override
        public String getApiKey() {
            return this.weaviateProperties.getClient().getApiKey();
        }
    }
}

