/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.bindings;

import io.thomasvitale.langchain4j.bindings.BindingsValidator;
import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.core.env.Environment;

public class OpenAiBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "open-ai";

    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!BindingsValidator.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            properties.put("langchain4j.open-ai.client.api-key", binding.getSecret().get("api-key"));
            properties.put("langchain4j.open-ai.client.base-url", binding.getSecret().get("uri"));
            properties.put("langchain4j.open-ai.client.organization-id", binding.getSecret().get("organization"));
            properties.put("langchain4j.open-ai.client.user", binding.getSecret().get("user"));
        });
    }
}

