/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.TokenUsage;
import io.thomasvitale.langchain4j.spring.ollama.api.ChatResponse;
import io.thomasvitale.langchain4j.spring.ollama.api.Message;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public final class OllamaAdapters {
    private static final List<String> SUPPORTED_URL_SCHEMES = Arrays.asList("http", "https", "file");

    public static Message.Role toOllamaRole(ChatMessage chatMessage) {
        return switch (chatMessage.type()) {
            case ChatMessageType.SYSTEM -> Message.Role.SYSTEM;
            case ChatMessageType.USER -> Message.Role.USER;
            case ChatMessageType.AI -> Message.Role.ASSISTANT;
            default -> throw new IllegalArgumentException("Unsupported message type: " + chatMessage.type());
        };
    }

    public static Message toOllamaMessage(ChatMessage chatMessage) {
        if (chatMessage instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)chatMessage;
            return Message.builder().role(OllamaAdapters.toOllamaRole(chatMessage)).content(systemMessage.text()).build();
        }
        if (chatMessage instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)chatMessage;
            return Message.builder().role(OllamaAdapters.toOllamaRole(chatMessage)).content(aiMessage.text()).build();
        }
        if (chatMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)chatMessage;
            if (userMessage.contents().stream().anyMatch(content -> ContentType.IMAGE.equals((Object)content.type()))) {
                return OllamaAdapters.toMessageWithImage(userMessage);
            }
            return OllamaAdapters.toMessageWithText(userMessage);
        }
        throw new IllegalArgumentException("Unsupported message class: " + chatMessage.getClass().getSimpleName());
    }

    public static TokenUsage toTokenUsage(ChatResponse chatResponse) {
        return new TokenUsage(chatResponse.promptEvalCount(), chatResponse.evalCount());
    }

    private static Message toMessageWithImage(UserMessage userMessage) {
        Map<ContentType, List<Content>> contentsByGroup = userMessage.contents().stream().collect(Collectors.groupingBy(Content::type));
        if (contentsByGroup.get(ContentType.TEXT).size() != 1) {
            throw new IllegalArgumentException("Expecting single text content, but got: " + userMessage.contents());
        }
        String textContents = ((TextContent)contentsByGroup.get(ContentType.TEXT).get(0)).text();
        List<ImageContent> imageContents = contentsByGroup.get(ContentType.IMAGE).stream().map(content -> (ImageContent)content).collect(Collectors.toList());
        return Message.builder().role(OllamaAdapters.toOllamaRole((ChatMessage)userMessage)).content(textContents).images(OllamaAdapters.toBase64EncodedImages(imageContents)).build();
    }

    private static Message toMessageWithText(UserMessage userMessage) {
        return Message.builder().role(OllamaAdapters.toOllamaRole((ChatMessage)userMessage)).content(userMessage.contents().stream().map(content -> (TextContent)content).map(TextContent::text).collect(Collectors.joining("\n"))).build();
    }

    private static List<String> toBase64EncodedImages(List<ImageContent> imageContents) {
        return imageContents.stream().map(ImageContent::image).map(OllamaAdapters::toBase64EncodedImage).collect(Collectors.toList());
    }

    private static String toBase64EncodedImage(Image image) {
        if (StringUtils.hasText((String)image.base64Data())) {
            return image.base64Data();
        }
        if (SUPPORTED_URL_SCHEMES.contains(image.url().getScheme())) {
            return image.url().getScheme().startsWith("http") ? OllamaAdapters.encodeImageFromHttp(image) : OllamaAdapters.encodeImageFromFile(image);
        }
        throw new IllegalArgumentException("The Ollama integration supports only http/https and file URLs. Unsupported URL scheme: " + image.url().getScheme());
    }

    private static String encodeImageFromHttp(Image image) {
        byte[] imageBytes = Utils.readBytes((String)image.url().toString());
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    private static String encodeImageFromFile(Image image) {
        byte[] imageFileBytes;
        try {
            File imageFile = ResourceUtils.getFile((URI)image.url());
            imageFileBytes = FileCopyUtils.copyToByteArray((File)imageFile);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read the image with path: %s".formatted(image.url()), ex);
        }
        return Base64.getEncoder().encodeToString(imageFileBytes);
    }
}

