/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.DefaultEmbeddingModelObservationConvention;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.EmbeddingModelObservationContext;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.EmbeddingModelObservationConvention;
import io.thomasvitale.langchain4j.spring.ollama.api.EmbeddingRequest;
import io.thomasvitale.langchain4j.spring.ollama.api.EmbeddingResponse;
import io.thomasvitale.langchain4j.spring.ollama.api.Options;
import io.thomasvitale.langchain4j.spring.ollama.client.OllamaClient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public class OllamaEmbeddingModel
implements EmbeddingModel {
    public static final String DEFAULT_MODEL = "llama2";
    private final OllamaClient ollamaClient;
    private final String model;
    private final Options options;
    private final ObservationRegistry observationRegistry;
    private final EmbeddingModelObservationConvention observationConvention = new DefaultEmbeddingModelObservationConvention();

    private OllamaEmbeddingModel(OllamaClient ollamaClient, String model, Options options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)ollamaClient, (String)"ollamaClient cannot be null");
        Assert.hasText((String)model, (String)"model cannot be null or empty");
        Assert.notNull((Object)ollamaClient, (String)"ollamaClient cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        this.ollamaClient = ollamaClient;
        this.model = model;
        this.options = options;
        this.observationRegistry = observationRegistry;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        ArrayList embeddings = new ArrayList();
        EmbeddingModelObservationContext observationContext = new EmbeddingModelObservationContext("ollama");
        observationContext.setModel(this.model);
        Response modelResponse = (Response)Observation.createNotStarted((ObservationConvention)this.observationConvention, () -> observationContext, (ObservationRegistry)this.observationRegistry).observe(() -> {
            textSegments.forEach(textSegment -> {
                EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().model(this.model).prompt(textSegment.text()).options(this.options).build();
                EmbeddingResponse embeddingResponse = this.ollamaClient.embeddings(embeddingRequest);
                if (embeddingResponse == null) {
                    throw new IllegalStateException("Embedding response is empty");
                }
                embeddings.add(Embedding.from(embeddingResponse.embedding()));
            });
            return Response.from((Object)embeddings);
        });
        if (modelResponse == null) {
            throw new IllegalStateException("Model response is empty");
        }
        return modelResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OllamaClient ollamaClient;
        private String model = "llama2";
        private Options options = Options.builder().build();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder client(OllamaClient ollamaClient) {
            this.ollamaClient = ollamaClient;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public OllamaEmbeddingModel build() {
            return new OllamaEmbeddingModel(this.ollamaClient, this.model, this.options, this.observationRegistry);
        }
    }
}

