/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.ollama.api.Message;
import io.thomasvitale.langchain4j.spring.ollama.api.Options;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record ChatRequest(String model, List<Message> messages, Boolean stream, String format, Duration keepAlive, Map<String, Object> options) {
    public ChatRequest {
        Assert.hasText((String)model, (String)"model must not be null or empty");
        Assert.notEmpty(messages, (String)"messages must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private List<Message> messages;
        private boolean stream = false;
        private String format;
        private Duration keepAlive;
        private Map<String, Object> options;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder keepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public Builder options(Options options) {
            this.options = options.toMap();
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.model, this.messages, this.stream, this.format, this.keepAlive, this.options);
        }
    }
}

