/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.ollama.api.Options;
import java.time.Duration;
import java.util.Map;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record EmbeddingRequest(String model, String prompt, Duration keepAlive, Map<String, Object> options) {
    public EmbeddingRequest {
        Assert.hasText((String)model, (String)"model must not be null or empty");
        Assert.hasText((String)prompt, (String)"prompt must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String prompt;
        private Duration keepAlive;
        private Map<String, Object> options;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder keepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public Builder options(Options options) {
            this.options = options.toMap();
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.prompt, this.keepAlive, this.options);
        }
    }
}

