/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record GenerateRequest(String model, String prompt, String system, String template, List<Integer> context, Boolean stream, Boolean raw, String format, Duration keepAlive, List<byte[]> images, Map<String, Object> options) {
    public GenerateRequest {
        Assert.hasText((String)model, (String)"model must not be null or empty");
        Assert.hasText((String)prompt, (String)"prompt must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String prompt;
        private String system;
        private String template;
        private List<Integer> context;
        private Boolean stream;
        private Boolean raw;
        private String format;
        private Duration keepAlive;
        private List<byte[]> images;
        private Map<String, Object> options;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder context(List<Integer> context) {
            this.context = context;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder raw(Boolean raw) {
            this.raw = raw;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder keepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder images(List<byte[]> images) {
            this.images = images;
            return this;
        }

        public Builder options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public GenerateRequest build() {
            return new GenerateRequest(this.model, this.prompt, this.system, this.template, this.context, this.stream, this.raw, this.format, this.keepAlive, this.images, this.options);
        }
    }
}

