/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record Message(Role role, String content, List<String> images) {
    public Message {
        Assert.notNull((Object)((Object)role), (String)"role must not be null");
        Assert.hasText((String)content, (String)"content must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Role {
        SYSTEM,
        USER,
        ASSISTANT;

    }

    public static class Builder {
        private Role role;
        private String content;
        private List<String> images;

        private Builder() {
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder images(List<String> images) {
            this.images = images;
            return this;
        }

        public Message build() {
            return new Message(this.role, this.content, this.images);
        }
    }
}

