/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.ollama.client;

import io.thomasvitale.langchain4j.spring.core.http.HttpLoggingInterceptor;
import io.thomasvitale.langchain4j.spring.core.http.HttpResponseErrorHandler;
import io.thomasvitale.langchain4j.spring.ollama.api.ChatRequest;
import io.thomasvitale.langchain4j.spring.ollama.api.ChatResponse;
import io.thomasvitale.langchain4j.spring.ollama.api.EmbeddingRequest;
import io.thomasvitale.langchain4j.spring.ollama.api.EmbeddingResponse;
import io.thomasvitale.langchain4j.spring.ollama.api.GenerateRequest;
import io.thomasvitale.langchain4j.spring.ollama.api.GenerateResponse;
import io.thomasvitale.langchain4j.spring.ollama.client.OllamaClientConfig;
import java.net.http.HttpClient;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OllamaClient {
    private static final Logger logger = LoggerFactory.getLogger(OllamaClient.class);
    private final HttpResponseErrorHandler responseErrorHandler;
    private final RestClient restClient;

    public OllamaClient(OllamaClientConfig clientConfig, RestClient.Builder restClientBuilder) {
        Assert.notNull((Object)clientConfig, (String)"clientOptions must not be null");
        Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder must not be null");
        this.responseErrorHandler = new HttpResponseErrorHandler();
        this.restClient = this.buildRestClient(clientConfig, restClientBuilder);
    }

    private RestClient buildRestClient(OllamaClientConfig clientConfig, RestClient.Builder restClientBuilder) {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(clientConfig.connectTimeout()).build();
        JdkClientHttpRequestFactory jdkClientHttpRequestFactory = new JdkClientHttpRequestFactory(httpClient);
        jdkClientHttpRequestFactory.setReadTimeout(clientConfig.readTimeout());
        Object requestFactory = clientConfig.logRequests() ? new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)jdkClientHttpRequestFactory) : jdkClientHttpRequestFactory;
        Consumer<HttpHeaders> defaultHeaders = headers -> {
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        };
        return restClientBuilder.requestFactory((ClientHttpRequestFactory)requestFactory).baseUrl(clientConfig.baseUrl().toString()).defaultHeaders(defaultHeaders).defaultStatusHandler((ResponseErrorHandler)this.responseErrorHandler).requestInterceptors(interceptors -> {
            if (clientConfig.logRequests() || clientConfig.logResponses()) {
                interceptors.add(new HttpLoggingInterceptor(clientConfig.logRequests(), clientConfig.logResponses()));
            }
        }).build();
    }

    @Nullable
    public GenerateResponse generate(GenerateRequest completionRequest) {
        Assert.notNull((Object)completionRequest, (String)"completionRequest must not be null");
        Assert.isTrue((completionRequest.stream() == false ? 1 : 0) != 0, (String)"Stream mode must be disabled");
        logger.debug("Sending completion request: {}", (Object)completionRequest);
        return (GenerateResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/generate", new Object[0])).body((Object)completionRequest).retrieve().body(GenerateResponse.class);
    }

    @Nullable
    public ChatResponse chat(ChatRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"chatRequest must not be null");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Stream mode must be disabled");
        logger.debug("Sending chat request: {}", (Object)chatRequest);
        return (ChatResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/chat", new Object[0])).body((Object)chatRequest).retrieve().body(ChatResponse.class);
    }

    @Nullable
    public EmbeddingResponse embeddings(EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"embeddingRequest must not be null");
        logger.debug("Sending embedding request: {}", (Object)embeddingRequest);
        return (EmbeddingResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/embeddings", new Object[0])).body((Object)embeddingRequest).retrieve().body(EmbeddingResponse.class);
    }
}

