/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionFinishReason;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionMessage;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionRequest;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionResponse;
import io.thomasvitale.langchain4j.spring.openai.api.chat.Tool;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingResponse;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageGenerationResponse;
import io.thomasvitale.langchain4j.spring.openai.api.shared.Usage;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public final class OpenAiAdapters {
    public static List<ChatCompletionMessage> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(OpenAiAdapters::toOpenAiMessage).toList();
    }

    private static ChatCompletionMessage toOpenAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            return ChatCompletionMessage.builder().role(ChatCompletionMessage.Role.SYSTEM).content(systemMessage.text()).build();
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            if (userMessage.hasSingleText()) {
                return ChatCompletionMessage.builder().role(ChatCompletionMessage.Role.USER).content(userMessage.text()).name(userMessage.name()).build();
            }
            return ChatCompletionMessage.builder().content(userMessage.contents().stream().map(OpenAiAdapters::toOpenAiContent).collect(Collectors.toList())).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return ChatCompletionMessage.builder().role(ChatCompletionMessage.Role.ASSISTANT).content(aiMessage.text()).build();
            }
            return ChatCompletionMessage.builder().role(ChatCompletionMessage.Role.ASSISTANT).toolCalls(OpenAiAdapters.toOpenAiToolCalls(aiMessage.toolExecutionRequests())).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            return ChatCompletionMessage.builder().role(ChatCompletionMessage.Role.TOOL).content(toolExecutionResultMessage.text()).toolCallId(toolExecutionResultMessage.id()).build();
        }
        throw new IllegalArgumentException("Unknown message type: " + message.type());
    }

    public static ChatCompletionMessage.Content toOpenAiContent(Content content) {
        if (ContentType.TEXT.equals((Object)content.type())) {
            TextContent textContent = (TextContent)content;
            return ChatCompletionMessage.Content.builder().type(ChatCompletionMessage.ContentType.TEXT).text(textContent.text()).build();
        }
        if (ContentType.IMAGE.equals((Object)content.type())) {
            ImageContent imageContent = (ImageContent)content;
            return ChatCompletionMessage.Content.builder().type(ChatCompletionMessage.ContentType.IMAGE_URL).imageUrl(new ChatCompletionMessage.ImageUrl(OpenAiAdapters.toOpenAiUrl(imageContent.image()), OpenAiAdapters.toOpenAiDetail(imageContent.detailLevel()))).build();
        }
        throw new IllegalArgumentException("Unknown content type: " + content.type());
    }

    private static String toOpenAiUrl(Image image) {
        if (image.url() != null) {
            return image.url().toString();
        }
        return String.format("data:%s;base64,%s", image.mimeType(), image.base64Data());
    }

    private static String toOpenAiDetail(ImageContent.DetailLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        return detailLevel.name();
    }

    private static List<ChatCompletionMessage.ToolCall> toOpenAiToolCalls(List<ToolExecutionRequest> toolExecutionRequests) {
        return toolExecutionRequests.stream().map(OpenAiAdapters::toOpenAiToolCall).toList();
    }

    private static ChatCompletionMessage.ToolCall toOpenAiToolCall(ToolExecutionRequest toolExecutionRequest) {
        ChatCompletionMessage.ChatCompletionFunction functionCall = new ChatCompletionMessage.ChatCompletionFunction(toolExecutionRequest.name(), toolExecutionRequest.arguments());
        return new ChatCompletionMessage.ToolCall(toolExecutionRequest.id(), functionCall);
    }

    public static ChatCompletionRequest.ToolChoice toOpenAiToolChoice(ToolSpecification toolSpecification) {
        return new ChatCompletionRequest.ToolChoice(toolSpecification.name());
    }

    public static List<Tool> toOpenAiTools(List<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(OpenAiAdapters::toOpenAiTool).toList();
    }

    private static Tool toOpenAiTool(ToolSpecification toolSpecification) {
        Tool.Function function = Tool.Function.builder().description(toolSpecification.description()).name(toolSpecification.name()).parameters(OpenAiAdapters.toOpenAiParameters(toolSpecification.parameters())).build();
        return new Tool(function);
    }

    private static Tool.Parameters toOpenAiParameters(@Nullable ToolParameters toolParameters) {
        if (toolParameters == null) {
            return Tool.Parameters.builder().build();
        }
        return Tool.Parameters.builder().properties(toolParameters.properties()).required(toolParameters.required()).build();
    }

    public static TokenUsage toTokenUsage(Usage usage) {
        return new TokenUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens());
    }

    public static AiMessage toAiMessage(ChatCompletionResponse response) {
        ChatCompletionMessage assistantMessage = response.choices().get(0).message();
        List<ChatCompletionMessage.ToolCall> toolCalls = assistantMessage.toolCalls();
        if (!CollectionUtils.isEmpty(toolCalls)) {
            List<ToolExecutionRequest> toolExecutionRequests = toolCalls.stream().filter(toolCall -> "function".equals(toolCall.type())).map(OpenAiAdapters::toToolExecutionRequest).toList();
            return AiMessage.from(toolExecutionRequests);
        }
        return AiMessage.from((String)((String)assistantMessage.content()));
    }

    private static ToolExecutionRequest toToolExecutionRequest(ChatCompletionMessage.ToolCall toolCall) {
        return ToolExecutionRequest.builder().id(toolCall.id()).name(toolCall.function().name()).arguments(toolCall.function().arguments()).build();
    }

    public static FinishReason toFinishReason(ChatCompletionFinishReason finishReason) {
        return switch (finishReason) {
            default -> throw new IncompatibleClassChangeError();
            case ChatCompletionFinishReason.STOP -> FinishReason.STOP;
            case ChatCompletionFinishReason.LENGTH -> FinishReason.LENGTH;
            case ChatCompletionFinishReason.TOOL_CALLS -> FinishReason.TOOL_EXECUTION;
            case ChatCompletionFinishReason.CONTENT_FILTER -> FinishReason.CONTENT_FILTER;
        };
    }

    public static Embedding toEmbedding(EmbeddingResponse.EmbeddingData embeddingData) {
        List<Float> floatVectors = embeddingData.embedding().stream().map(Double::floatValue).toList();
        return Embedding.from(floatVectors);
    }

    public static Image toImage(ImageGenerationResponse.ImageData imageData) {
        return Image.builder().url(imageData.url()).base64Data(imageData.b64Json()).revisedPrompt(imageData.revisedPrompt()).build();
    }
}

