/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.thomasvitale.langchain4j.spring.core.chat.observation.ChatModelObservationContext;
import io.thomasvitale.langchain4j.spring.core.chat.observation.ChatModelObservationConvention;
import io.thomasvitale.langchain4j.spring.core.chat.observation.DefaultChatModelObservationConvention;
import io.thomasvitale.langchain4j.spring.openai.OpenAiAdapters;
import io.thomasvitale.langchain4j.spring.openai.OpenAiChatOptions;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionRequest;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionResponse;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiClient;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class OpenAiChatModel
implements ChatLanguageModel {
    private final OpenAiClient openAiClient;
    private final OpenAiChatOptions options;
    private final ObservationRegistry observationRegistry;
    private final ChatModelObservationConvention observationConvention = new DefaultChatModelObservationConvention();

    private OpenAiChatModel(OpenAiClient openAiClient, OpenAiChatOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiClient, (String)"openAiClient cannot be null");
        Assert.notNull((Object)options, (String)"options cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        this.openAiClient = openAiClient;
        this.options = options;
        this.observationRegistry = observationRegistry;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, @Nullable List<ToolSpecification> toolSpecifications, @Nullable ToolSpecification toolThatMustBeExecuted) {
        ChatCompletionRequest.Builder chatCompletionRequestBuilder = ChatCompletionRequest.builder().messages(OpenAiAdapters.toOpenAiMessages(messages)).model(this.options.getModel()).frequencyPenalty(this.options.getFrequencyPenalty()).logitBias(this.options.getLogitBias()).logprobs(this.options.getLogprobs()).topLogprobs(this.options.getTopLogprobs()).maxTokens(this.options.getMaxTokens()).n(this.options.getN()).presencePenalty(this.options.getPresencePenalty()).responseFormat(this.options.getResponseFormat()).seed(this.options.getSeed()).stop(this.options.getStop()).temperature(this.options.getTemperature()).topP(this.options.getTopP()).user(this.options.getUser());
        if (!CollectionUtils.isEmpty(toolSpecifications)) {
            chatCompletionRequestBuilder.tools(OpenAiAdapters.toOpenAiTools(toolSpecifications));
        }
        if (toolThatMustBeExecuted != null) {
            chatCompletionRequestBuilder.toolChoice(OpenAiAdapters.toOpenAiToolChoice(toolThatMustBeExecuted));
        }
        ChatCompletionRequest request = chatCompletionRequestBuilder.build();
        ChatModelObservationContext observationContext = new ChatModelObservationContext("openai");
        observationContext.setModel(this.options.getModel());
        observationContext.setMessages(messages);
        observationContext.setTemperature(this.options.getTemperature());
        Response modelResponse = (Response)Observation.createNotStarted((ObservationConvention)this.observationConvention, () -> observationContext, (ObservationRegistry)this.observationRegistry).observe(() -> {
            ChatCompletionResponse response = this.openAiClient.chatCompletion(request);
            if (response == null) {
                return null;
            }
            TokenUsage tokenUsage = OpenAiAdapters.toTokenUsage(response.usage());
            FinishReason finishReason = OpenAiAdapters.toFinishReason(response.choices().get(0).finishReason());
            observationContext.setTokenUsage(tokenUsage);
            observationContext.setFinishReason(finishReason);
            return Response.from((Object)OpenAiAdapters.toAiMessage(response), (TokenUsage)tokenUsage, (FinishReason)finishReason);
        });
        if (modelResponse == null) {
            throw new IllegalStateException("Model response is empty");
        }
        return modelResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OpenAiClient openAiClient;
        private OpenAiChatOptions options;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        public Builder client(OpenAiClient openAiClient) {
            this.openAiClient = openAiClient;
            return this;
        }

        public Builder options(OpenAiChatOptions options) {
            this.options = options;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public OpenAiChatModel build() {
            return new OpenAiChatModel(this.openAiClient, this.options, this.observationRegistry);
        }
    }
}

