/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionRequest;
import io.thomasvitale.langchain4j.spring.openai.api.chat.Tool;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiChatOptions {
    public static final String DEFAULT_MODEL = "gpt-3.5-turbo";
    private String model;
    private Double frequencyPenalty = 0.0;
    private Map<String, Integer> logitBias;
    private Boolean logprobs = false;
    private Integer topLogprobs;
    private Integer maxTokens;
    private Integer n = 1;
    private Double presencePenalty = 0.0;
    private ChatCompletionRequest.ResponseFormat responseFormat = new ChatCompletionRequest.ResponseFormat("text");
    private Integer seed;
    private List<String> stop;
    private Double temperature = 0.7;
    private Double topP;
    @NestedConfigurationProperty
    private List<Tool> tools;
    @NestedConfigurationProperty
    private ChatCompletionRequest.ToolChoice toolChoice;
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public ChatCompletionRequest.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(ChatCompletionRequest.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static class Builder {
        private final OpenAiChatOptions options = new OpenAiChatOptions();

        private Builder() {
            this.options.model = OpenAiChatOptions.DEFAULT_MODEL;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder n(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(ChatCompletionRequest.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public OpenAiChatOptions build() {
            return this.options;
        }
    }
}

