/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.DefaultEmbeddingModelObservationConvention;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.EmbeddingModelObservationContext;
import io.thomasvitale.langchain4j.spring.core.embedding.observation.EmbeddingModelObservationConvention;
import io.thomasvitale.langchain4j.spring.openai.OpenAiAdapters;
import io.thomasvitale.langchain4j.spring.openai.OpenAiEmbeddingOptions;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingRequest;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingResponse;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.Assert;

public class OpenAiEmbeddingModel
implements EmbeddingModel {
    private final OpenAiClient openAiClient;
    private final OpenAiEmbeddingOptions options;
    private final ObservationRegistry observationRegistry;
    private final EmbeddingModelObservationConvention observationConvention = new DefaultEmbeddingModelObservationConvention();

    private OpenAiEmbeddingModel(OpenAiClient openAiClient, OpenAiEmbeddingOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiClient, (String)"openAiClient cannot be null");
        Assert.notNull((Object)options, (String)"options cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        this.openAiClient = openAiClient;
        this.options = options;
        this.observationRegistry = observationRegistry;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        ArrayList embeddings = new ArrayList();
        AtomicInteger promptTokens = new AtomicInteger();
        EmbeddingModelObservationContext observationContext = new EmbeddingModelObservationContext("openai");
        observationContext.setModel(this.options.getModel());
        Response modelResponse = (Response)Observation.createNotStarted((ObservationConvention)this.observationConvention, () -> observationContext, (ObservationRegistry)this.observationRegistry).observe(() -> {
            textSegments.forEach(textSegment -> {
                EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().input(List.of(textSegment.text())).model(this.options.getModel()).encodingFormat(this.options.getEncodingFormat()).dimensions(this.options.getDimensions()).user(this.options.getUser()).build();
                EmbeddingResponse embeddingResponse = this.openAiClient.embeddings(embeddingRequest);
                if (embeddingResponse == null) {
                    throw new IllegalStateException("Embedding response is empty");
                }
                promptTokens.addAndGet(embeddingResponse.usage().promptTokens());
                embeddings.addAll(embeddingResponse.data().stream().map(OpenAiAdapters::toEmbedding).toList());
            });
            TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(promptTokens.get()));
            observationContext.setTokenUsage(tokenUsage);
            return Response.from((Object)embeddings, (TokenUsage)tokenUsage);
        });
        if (modelResponse == null) {
            throw new IllegalStateException("Model response is empty");
        }
        return modelResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OpenAiClient openAiClient;
        private OpenAiEmbeddingOptions options = OpenAiEmbeddingOptions.builder().build();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder client(OpenAiClient openAiClient) {
            this.openAiClient = openAiClient;
            return this;
        }

        public Builder options(OpenAiEmbeddingOptions options) {
            this.options = options;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public OpenAiEmbeddingModel build() {
            return new OpenAiEmbeddingModel(this.openAiClient, this.options, this.observationRegistry);
        }
    }
}

