/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingModels;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class OpenAiEmbeddingOptions {
    private String model = EmbeddingModels.TEXT_EMBEDDING_ADA_002.toString();
    private String encodingFormat = "float";
    private Integer dimensions;
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static class Builder {
        protected final OpenAiEmbeddingOptions options = new OpenAiEmbeddingOptions();

        private Builder() {
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder encodingFormat(String encodingFormat) {
            this.options.encodingFormat = encodingFormat;
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public OpenAiEmbeddingOptions build() {
            return this.options;
        }
    }
}

