/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.thomasvitale.langchain4j.spring.core.image.observation.DefaultImageModelObservationConvention;
import io.thomasvitale.langchain4j.spring.core.image.observation.ImageModelObservationContext;
import io.thomasvitale.langchain4j.spring.core.image.observation.ImageModelObservationConvention;
import io.thomasvitale.langchain4j.spring.openai.OpenAiAdapters;
import io.thomasvitale.langchain4j.spring.openai.OpenAiImageOptions;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageGenerationRequest;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageGenerationResponse;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiClient;
import java.util.List;
import org.springframework.util.Assert;

public class OpenAiImageModel
implements ImageModel {
    private final OpenAiClient openAiClient;
    private final OpenAiImageOptions options;
    private final ObservationRegistry observationRegistry;
    private final ImageModelObservationConvention observationConvention = new DefaultImageModelObservationConvention();

    private OpenAiImageModel(OpenAiClient openAiClient, OpenAiImageOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiClient, (String)"openAiClient cannot be null");
        Assert.notNull((Object)options, (String)"options cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        this.openAiClient = openAiClient;
        this.options = options;
        this.observationRegistry = observationRegistry;
    }

    public Response<Image> generate(String prompt) {
        ImageGenerationRequest request = this.imageGenerationRequestBuilder(prompt).build();
        ImageModelObservationContext observationContext = new ImageModelObservationContext("openai");
        observationContext.setModel(this.options.getModel());
        observationContext.setNumber(1);
        Response modelResponse = (Response)Observation.createNotStarted((ObservationConvention)this.observationConvention, () -> observationContext, (ObservationRegistry)this.observationRegistry).observe(() -> {
            ImageGenerationResponse response = this.openAiClient.imageGeneration(request);
            if (response == null) {
                return null;
            }
            return Response.from((Object)OpenAiAdapters.toImage(response.data().get(0)));
        });
        if (modelResponse == null) {
            throw new IllegalStateException("Model response is empty");
        }
        return modelResponse;
    }

    public Response<List<Image>> generate(String prompt, int n) {
        ImageGenerationRequest request = this.imageGenerationRequestBuilder(prompt).n(n).build();
        ImageModelObservationContext observationContext = new ImageModelObservationContext("openai");
        observationContext.setModel(this.options.getModel());
        observationContext.setNumber(n);
        Response modelResponse = (Response)Observation.createNotStarted((ObservationConvention)this.observationConvention, () -> observationContext, (ObservationRegistry)this.observationRegistry).observe(() -> {
            ImageGenerationResponse response = this.openAiClient.imageGeneration(request);
            if (response == null) {
                return null;
            }
            return Response.from(response.data().stream().map(OpenAiAdapters::toImage).toList());
        });
        if (modelResponse == null) {
            throw new IllegalStateException("Model response is empty");
        }
        return modelResponse;
    }

    private ImageGenerationRequest.Builder imageGenerationRequestBuilder(String prompt) {
        return ImageGenerationRequest.builder().prompt(prompt).model(this.options.getModel()).n(this.options.getN()).quality(this.options.getQuality()).responseFormat(this.options.getResponseFormat()).size(this.options.getSize()).style(this.options.getStyle()).user(this.options.getUser());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OpenAiClient openAiClient;
        private OpenAiImageOptions options = new OpenAiImageOptions();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder client(OpenAiClient openAiClient) {
            this.openAiClient = openAiClient;
            return this;
        }

        public Builder options(OpenAiImageOptions options) {
            this.options = options;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public OpenAiImageModel build() {
            return new OpenAiImageModel(this.openAiClient, this.options, this.observationRegistry);
        }
    }
}

