/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai;

import io.thomasvitale.langchain4j.spring.openai.api.image.ImageModels;
import java.nio.file.Path;
import java.nio.file.Paths;

public class OpenAiImageOptions {
    private String model = ImageModels.DALL_E_2.toString();
    private Integer n = 1;
    private String quality;
    private String responseFormat;
    private String size;
    private String style;
    private String user;
    private Boolean persist = false;
    private Path persistDirectory = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getPersist() {
        return this.persist;
    }

    public void setPersist(Boolean persist) {
        this.persist = persist;
    }

    public Path getPersistDirectory() {
        return this.persistDirectory;
    }

    public void setPersistDirectory(Path persistDirectory) {
        this.persistDirectory = persistDirectory;
    }

    public static class Builder {
        private final OpenAiImageOptions options = new OpenAiImageOptions();

        private Builder() {
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder n(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder quality(String quality) {
            this.options.quality = quality;
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder size(String size) {
            this.options.size = size;
            return this;
        }

        public Builder style(String style) {
            this.options.style = style;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        public Builder persist(Boolean persist) {
            this.options.persist = persist;
            return this;
        }

        public Builder persistDirectory(Path persistDirectory) {
            this.options.persistDirectory = persistDirectory;
            return this;
        }

        public OpenAiImageOptions build() {
            return this.options;
        }
    }
}

