/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record ChatCompletionMessage(Object content, Role role, String name, String toolCallId, List<ToolCall> toolCalls) {
    public ChatCompletionMessage {
        Assert.notNull((Object)((Object)role), (String)"role cannot be null");
        if (Role.SYSTEM.equals((Object)role) || Role.USER.equals((Object)role)) {
            Assert.notNull((Object)content, (String)"content cannot be null");
        }
        if (Role.ASSISTANT.equals((Object)role) && CollectionUtils.isEmpty(toolCalls)) {
            Assert.notNull((Object)content, (String)"content cannot be null");
        }
        if (Role.TOOL.equals((Object)role)) {
            Assert.notNull((Object)content, (String)"content cannot be null");
            Assert.hasText((String)toolCallId, (String)"toolCallId cannot be null or empty");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Role {
        SYSTEM,
        USER,
        ASSISTANT,
        TOOL;

    }

    public static class Builder {
        private Object content;
        private Role role;
        private String name;
        private String toolCallId;
        private List<ToolCall> toolCalls;

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder content(List<Content> content) {
            this.content = content;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public ChatCompletionMessage build() {
            return new ChatCompletionMessage(this.content, this.role, this.name, this.toolCallId, this.toolCalls);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionFunction(String name, String arguments) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ToolCall(String id, String type, ChatCompletionFunction function) {
        public ToolCall(String id, ChatCompletionFunction function) {
            this(id, "function", function);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ImageUrl(String url, String detail) {
    }

    public static enum ContentType {
        TEXT,
        IMAGE_URL;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public record Content(ContentType type, String text, ImageUrl imageUrl) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private ContentType type;
            private String text;
            private ImageUrl imageUrl;

            private Builder() {
            }

            public Builder type(ContentType type) {
                this.type = type;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder imageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Content build() {
                return new Content(this.type, this.text, this.imageUrl);
            }
        }
    }
}

