/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionMessage;
import io.thomasvitale.langchain4j.spring.openai.api.chat.Tool;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double frequencyPenalty, Map<String, Integer> logitBias, boolean logprobs, Integer topLogprobs, Integer maxTokens, Integer n, Double presencePenalty, ResponseFormat responseFormat, Integer seed, List<String> stop, Boolean stream, Double temperature, Double topP, List<Tool> tools, ToolChoice toolChoice, String user) {
    public ChatCompletionRequest {
        Assert.notEmpty(messages, (String)"messages must not be null or empty");
        Assert.hasText((String)model, (String)"model must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ResponseFormat(String type) {
        public ResponseFormat {
            Assert.hasText((String)type, (String)"type must not be null or empty");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ToolChoice(String type, Function function) {
        public ToolChoice {
            Assert.hasText((String)type, (String)"type must not be null or empty");
            Assert.notNull((Object)function, (String)"function must not be null");
        }

        @ConstructorBinding
        public ToolChoice(String functionName) {
            this("function", new Function(functionName));
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Function(String name) {
            public Function {
                Assert.hasText((String)name, (String)"name must not be null or empty");
            }
        }
    }

    public static class Builder {
        private List<ChatCompletionMessage> messages;
        private String model;
        private Double frequencyPenalty = 0.0;
        private Map<String, Integer> logitBias;
        private boolean logprobs = false;
        private Integer topLogprobs;
        private Integer maxTokens;
        private Integer n = 1;
        private Double presencePenalty = 0.0;
        private ResponseFormat responseFormat = new ResponseFormat("text");
        private Integer seed;
        private List<String> stop;
        private Boolean stream = false;
        private Double temperature = 1.0;
        private Double topP;
        private List<Tool> tools;
        private ToolChoice toolChoice;
        private String user;

        private Builder() {
        }

        public Builder messages(List<ChatCompletionMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this.messages, this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }
    }
}

