/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record Tool(Type type, Function function) {
    public Tool {
        Assert.notNull((Object)((Object)type), (String)"type cannot be null");
        Assert.notNull((Object)function, (String)"function cannot be null");
    }

    @ConstructorBinding
    public Tool(Function function) {
        this(Type.FUNCTION, function);
    }

    public static enum Type {
        FUNCTION;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Function(String description, String name, Parameters parameters) {
        public Function {
            Assert.hasText((String)name, (String)"name cannot be null or empty");
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String description;
            private String name;
            private Parameters parameters;

            private Builder() {
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder parameters(Parameters parameters) {
                this.parameters = parameters;
                return this;
            }

            public Function build() {
                return new Function(this.description, this.name, this.parameters);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Parameters(String type, Map<String, Map<String, Object>> properties, List<String> required) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final String type = "object";
            private Map<String, Map<String, Object>> properties;
            private List<String> required;

            private Builder() {
            }

            public Builder properties(Map<String, Map<String, Object>> properties) {
                this.properties = properties;
                return this;
            }

            public Builder required(List<String> required) {
                this.required = required;
                return this;
            }

            public Parameters build() {
                return new Parameters("object", this.properties, this.required);
            }
        }
    }
}

