/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.embedding;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingModels;
import java.util.List;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record EmbeddingRequest(List<String> input, String model, String encodingFormat, Integer dimensions, String user) {
    public EmbeddingRequest {
        Assert.notEmpty(input, (String)"Input must not be null or empty");
        Assert.isTrue((input.size() <= 2048 ? 1 : 0) != 0, (String)"Input must be 2048 dimensions or less");
        Assert.hasText((String)model, (String)"Model must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> input;
        private String model = EmbeddingModels.TEXT_EMBEDDING_ADA_002.toString();
        private String encodingFormat = "float";
        private Integer dimensions;
        private String user;

        private Builder() {
        }

        public Builder input(List<String> input) {
            this.input = input;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder encodingFormat(String encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.input, this.model, this.encodingFormat, this.dimensions, this.user);
        }
    }
}

