/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageModels;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public record ImageGenerationRequest(String prompt, String model, Integer n, String quality, String responseFormat, String size, String style, String user) {
    public ImageGenerationRequest {
        Assert.hasText((String)prompt, (String)"prompt must not be null or empty");
        Assert.hasText((String)model, (String)"model must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String prompt;
        private String model = ImageModels.DALL_E_2.toString();
        private Integer n = 1;
        private String quality;
        private String responseFormat;
        private String size;
        private String style;
        private String user;

        private Builder() {
        }

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public ImageGenerationRequest build() {
            return new ImageGenerationRequest(this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user);
        }
    }
}

