/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.api.moderation;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.thomasvitale.langchain4j.spring.openai.api.moderation.ModerationModels;
import java.util.List;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record ModerationRequest(List<String> input, String model) {
    public ModerationRequest {
        Assert.notEmpty(input, (String)"Input must not be null or empty");
        Assert.hasText((String)model, (String)"Model must not be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> input;
        private String model = ModerationModels.TEXT_MODERATION_LATEST.toString();

        private Builder() {
        }

        public Builder input(List<String> input) {
            this.input = input;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public ModerationRequest build() {
            return new ModerationRequest(this.input, this.model);
        }
    }
}

