/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.client;

import io.thomasvitale.langchain4j.spring.core.http.HttpLoggingInterceptor;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionRequest;
import io.thomasvitale.langchain4j.spring.openai.api.chat.ChatCompletionResponse;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingRequest;
import io.thomasvitale.langchain4j.spring.openai.api.embedding.EmbeddingResponse;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageGenerationRequest;
import io.thomasvitale.langchain4j.spring.openai.api.image.ImageGenerationResponse;
import io.thomasvitale.langchain4j.spring.openai.api.moderation.ModerationRequest;
import io.thomasvitale.langchain4j.spring.openai.api.moderation.ModerationResponse;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiClientConfig;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiResponseErrorHandler;
import java.net.http.HttpClient;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiClient {
    private final Logger logger = LoggerFactory.getLogger(OpenAiClient.class);
    private final ResponseErrorHandler responseErrorHandler;
    private final RestClient restClient;

    public OpenAiClient(OpenAiClientConfig clientConfig, RestClient.Builder restClientBuilder) {
        Assert.notNull((Object)clientConfig, (String)"clientOptions must not be null");
        Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder must not be null");
        this.responseErrorHandler = new OpenAiResponseErrorHandler();
        this.restClient = this.buildRestClient(clientConfig, restClientBuilder);
    }

    private RestClient buildRestClient(OpenAiClientConfig clientConfig, RestClient.Builder restClientBuilder) {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(clientConfig.connectTimeout()).build();
        JdkClientHttpRequestFactory jdkClientHttpRequestFactory = new JdkClientHttpRequestFactory(httpClient);
        jdkClientHttpRequestFactory.setReadTimeout(clientConfig.readTimeout());
        Object requestFactory = clientConfig.logRequests() ? new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)jdkClientHttpRequestFactory) : jdkClientHttpRequestFactory;
        Consumer<HttpHeaders> defaultHeaders = headers -> {
            headers.setContentType(MediaType.APPLICATION_JSON);
            if (StringUtils.hasText((String)clientConfig.apiKey())) {
                headers.setBearerAuth(clientConfig.apiKey());
            }
        };
        return restClientBuilder.requestFactory((ClientHttpRequestFactory)requestFactory).baseUrl(clientConfig.baseUrl().toString()).defaultHeaders(defaultHeaders).defaultStatusHandler(this.responseErrorHandler).requestInterceptors(interceptors -> {
            if (clientConfig.logRequests() || clientConfig.logResponses()) {
                interceptors.add(new HttpLoggingInterceptor(clientConfig.logRequests(), clientConfig.logResponses()));
            }
        }).build();
    }

    @Nullable
    public ChatCompletionResponse chatCompletion(ChatCompletionRequest chatCompletionRequest) {
        Assert.notNull((Object)chatCompletionRequest, (String)"chatCompletionRequest cannot be null");
        Assert.isTrue((chatCompletionRequest.stream() == false ? 1 : 0) != 0, (String)"Stream mode must be disabled");
        this.logger.debug("Sending chat completion request: {}", (Object)chatCompletionRequest);
        return (ChatCompletionResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/chat/completions", new Object[0])).body((Object)chatCompletionRequest).retrieve().body(ChatCompletionResponse.class);
    }

    @Nullable
    public EmbeddingResponse embeddings(EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"embeddingRequest cannot be null");
        this.logger.debug("Sending embedding request: {}", (Object)embeddingRequest);
        return (EmbeddingResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/embeddings", new Object[0])).body((Object)embeddingRequest).retrieve().body(EmbeddingResponse.class);
    }

    @Nullable
    public ImageGenerationResponse imageGeneration(ImageGenerationRequest imageGenerationRequest) {
        Assert.notNull((Object)imageGenerationRequest, (String)"imageGenerationRequest cannot be null.");
        this.logger.debug("Sending image generation request: {}", (Object)imageGenerationRequest);
        return (ImageGenerationResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("v1/images/generations", new Object[0])).body((Object)imageGenerationRequest).retrieve().body(ImageGenerationResponse.class);
    }

    @Nullable
    public ModerationResponse moderation(ModerationRequest moderationRequest) {
        Assert.notNull((Object)moderationRequest, (String)"moderationRequest cannot be null.");
        this.logger.debug("Sending moderation request: {}", (Object)moderationRequest);
        return (ModerationResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("v1/moderations", new Object[0])).body((Object)moderationRequest).retrieve().body(ModerationResponse.class);
    }
}

