/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.openai.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.thomasvitale.langchain4j.spring.openai.client.OpenAiResponseException;
import io.thomasvitale.langchain4j.spring.openai.client.ResponseError;
import java.io.IOException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class OpenAiResponseErrorHandler
implements ResponseErrorHandler {
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return response.getStatusCode().isError();
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        if (response.getStatusCode().isError()) {
            throw new OpenAiResponseException(String.format("%s - %s", response.getStatusCode().value(), this.objectMapper.readValue(response.getBody(), ResponseError.class)));
        }
    }
}

