/*
 * Decompiled with CFR 0.152.
 */
package io.thomasvitale.langchain4j.spring.weaviate;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.thomasvitale.langchain4j.spring.weaviate.WeaviateAdapters;
import io.thomasvitale.langchain4j.spring.weaviate.client.WeaviateClientConfig;
import io.weaviate.client.Config;
import io.weaviate.client.WeaviateAuthClient;
import io.weaviate.client.WeaviateClient;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.v1.auth.exception.AuthException;
import io.weaviate.client.v1.batch.model.ObjectGetResponse;
import io.weaviate.client.v1.batch.model.ObjectsGetResponseAO2Result;
import io.weaviate.client.v1.data.model.WeaviateObject;
import io.weaviate.client.v1.graphql.model.GraphQLError;
import io.weaviate.client.v1.graphql.model.GraphQLResponse;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.builder.GetBuilder;
import io.weaviate.client.v1.graphql.query.fields.Field;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WeaviateEmbeddingStore
implements EmbeddingStore<TextSegment> {
    public static final String DEFAULT_CONSISTENCY_LEVEL = "ALL";
    public static final String DEFAULT_OBJECT_CLASS_NAME = "LangChain4jClass";
    static final String ADDITIONAL_FIELD_NAME = "_additional";
    static final String ADDITIONAL_ID_FIELD_NAME = "id";
    static final String ADDITIONAL_CERTAINTY_FIELD_NAME = "certainty";
    static final String ADDITIONAL_VECTOR_FIELD_NAME = "vector";
    static final String CONTENT_FIELD_NAME = "text";
    private final WeaviateClient weaviateClient;
    private final String objectClassName;
    private final String consistencyLevel;

    private WeaviateEmbeddingStore(WeaviateClientConfig clientConfig, @Nullable String objectClassName, @Nullable String consistencyLevel) {
        Assert.notNull((Object)clientConfig, (String)"clientConfig cannot be null");
        Config weaviateVectorStoreConfig = new Config(clientConfig.url().getScheme(), WeaviateEmbeddingStore.computeFullHostFromUrl(clientConfig.url()), Objects.requireNonNullElse(clientConfig.headers(), Map.of()), (int)clientConfig.connectTimeout().toSeconds(), (int)clientConfig.readTimeout().toSeconds(), (int)clientConfig.readTimeout().toSeconds());
        try {
            this.weaviateClient = WeaviateAuthClient.apiKey((Config)weaviateVectorStoreConfig, (String)Objects.requireNonNullElse(clientConfig.apiKey(), ""));
        }
        catch (AuthException ex) {
            throw new IllegalArgumentException("Failed to create Weaviate client with API Key", ex);
        }
        this.objectClassName = StringUtils.hasText((String)objectClassName) ? objectClassName : DEFAULT_OBJECT_CLASS_NAME;
        this.consistencyLevel = StringUtils.hasText((String)consistencyLevel) ? consistencyLevel : DEFAULT_CONSISTENCY_LEVEL;
    }

    private static String computeFullHostFromUrl(URI url) {
        if (url.getPort() == -1) {
            return url.getHost();
        }
        return url.getHost() + ":" + url.getPort();
    }

    public String add(Embedding embedding) {
        Assert.notNull((Object)embedding, (String)"embedding cannot be null");
        String id = Utils.randomUUID();
        this.sendAddEmbeddingsRequest(List.of(id), List.of(embedding), null);
        return id;
    }

    public void add(String id, Embedding embedding) {
        Assert.hasText((String)id, (String)"id cannot be null or empty");
        Assert.notNull((Object)embedding, (String)"embedding cannot be null");
        this.sendAddEmbeddingsRequest(List.of(id), List.of(embedding), null);
    }

    public String add(Embedding embedding, @Nullable TextSegment textSegment) {
        Assert.notNull((Object)embedding, (String)"embedding cannot be null");
        String id = Utils.randomUUID();
        this.sendAddEmbeddingsRequest(List.of(id), List.of(embedding), textSegment == null ? null : List.of(textSegment));
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        Assert.notNull(embeddings, (String)"embeddings cannot be null");
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).toList();
        this.sendAddEmbeddingsRequest(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, @Nullable List<TextSegment> textSegments) {
        Assert.notNull(embeddings, (String)"embeddings cannot be null");
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).toList();
        this.sendAddEmbeddingsRequest(ids, embeddings, textSegments);
        return ids;
    }

    private void sendAddEmbeddingsRequest(List<String> ids, List<Embedding> embeddings, @Nullable List<TextSegment> textSegments) {
        ArrayList<WeaviateObject> weaviateObjects = new ArrayList<WeaviateObject>();
        for (int i = 0; i < embeddings.size(); ++i) {
            weaviateObjects.add(this.toWeaviateObject(ids.get(i), embeddings.get(i), CollectionUtils.isEmpty(textSegments) ? "" : textSegments.get(i).text()));
        }
        Result response = this.weaviateClient.batch().objectsBatcher().withObjects(weaviateObjects.toArray(new WeaviateObject[0])).withConsistencyLevel(this.consistencyLevel).run();
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (response.hasErrors()) {
            errorMessages.add(response.getError().getMessages().stream().map(WeaviateErrorMessage::getMessage).collect(Collectors.joining("\n")));
            throw new RuntimeException("Failed to add documents because: \n" + errorMessages);
        }
        if (response.getResult() != null) {
            for (ObjectGetResponse r : (ObjectGetResponse[])response.getResult()) {
                if (r.getResult() == null || r.getResult().getErrors() == null) continue;
                ObjectsGetResponseAO2Result.ErrorResponse error = r.getResult().getErrors();
                errorMessages.add(error.getError().stream().map(ObjectsGetResponseAO2Result.ErrorItem::getMessage).collect(Collectors.joining("\n")));
            }
        }
        if (!CollectionUtils.isEmpty(errorMessages)) {
            throw new RuntimeException("Failed to add documents because: \n" + errorMessages);
        }
    }

    private WeaviateObject toWeaviateObject(String id, Embedding embedding, String text) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(CONTENT_FIELD_NAME, text);
        return WeaviateObject.builder().className(this.objectClassName).id(id).vector(embedding.vectorAsList().toArray(new Float[0])).properties(fields).build();
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        Assert.notNull((Object)referenceEmbedding, (String)"referenceEmbedding cannot be null");
        Assert.isTrue((maxResults >= 1 ? 1 : 0) != 0, (String)"maxResults must be greater than or equal to 1");
        Assert.isTrue((minScore >= 0.0 && minScore <= 1.0 ? 1 : 0) != 0, (String)"minScore must be between 0 and 1 (inclusive)");
        GetBuilder.GetBuilderBuilder builder = GetBuilder.builder();
        List<Field> searchFields = List.of(Field.builder().name(CONTENT_FIELD_NAME).build(), Field.builder().name(ADDITIONAL_FIELD_NAME).fields(new Field[]{Field.builder().name(ADDITIONAL_ID_FIELD_NAME).build(), Field.builder().name(ADDITIONAL_CERTAINTY_FIELD_NAME).build(), Field.builder().name(ADDITIONAL_VECTOR_FIELD_NAME).build()}).build());
        GetBuilder queryBuilder = builder.className(this.objectClassName).withNearVectorFilter(NearVectorArgument.builder().vector(referenceEmbedding.vectorAsList().toArray(new Float[0])).certainty(Float.valueOf((float)minScore)).build()).limit(Integer.valueOf(maxResults)).fields(Fields.builder().fields(searchFields.toArray(new Field[0])).build()).build();
        String graphQLQuery = queryBuilder.buildQuery();
        Result result = this.weaviateClient.graphQL().raw().withQuery(graphQLQuery).run();
        if (result.hasErrors()) {
            throw new IllegalArgumentException(result.getError().getMessages().stream().map(WeaviateErrorMessage::getMessage).collect(Collectors.joining("\n")));
        }
        GraphQLError[] errors = ((GraphQLResponse)result.getResult()).getErrors();
        if (errors != null && errors.length > 0) {
            throw new IllegalArgumentException(Arrays.stream(errors).map(GraphQLError::getMessage).collect(Collectors.joining("\n")));
        }
        GraphQLResponse response = (GraphQLResponse)result.getResult();
        Optional responseData = ((Map)response.getData()).entrySet().stream().findFirst();
        if (responseData.isEmpty()) {
            return List.of();
        }
        Optional responseDataItemsPart = ((Map)((Map.Entry)responseData.get()).getValue()).entrySet().stream().findFirst();
        if (responseDataItemsPart.isEmpty()) {
            return List.of();
        }
        List responseItems = (List)((Map.Entry)responseDataItemsPart.get()).getValue();
        return responseItems.stream().map(WeaviateAdapters::toEmbeddingMatch).toList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WeaviateClientConfig clientConfig;
        private String objectClassName;
        private String consistencyLevel;

        private Builder() {
        }

        public Builder clientConfig(WeaviateClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder objectClassName(String objectClassName) {
            this.objectClassName = objectClassName;
            return this;
        }

        public Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public WeaviateEmbeddingStore build() {
            return new WeaviateEmbeddingStore(this.clientConfig, this.objectClassName, this.consistencyLevel);
        }
    }
}

