/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.swarm.arquillian.daemon.ContextManager;

public class TestRunner {
    private static final String CLASS_NAME_ARQ_TEST_RUNNERS = "org.jboss.arquillian.container.test.spi.util.TestRunners";
    private static final String METHOD_NAME_GET_TEST_RUNNER = "getTestRunner";
    private static final String METHOD_NAME_EXECUTE = "execute";
    private final DeploymentUnit deploymentUnit;

    public TestRunner(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable executeTest(String testClassName, String methodName) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Class testRunnersClass;
            Class testClass;
            ModuleClassLoader classLoader = ((Module)this.deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            try {
                testClass = classLoader.loadClass(testClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class " + testClassName);
            }
            try {
                testRunnersClass = classLoader.loadClass(CLASS_NAME_ARQ_TEST_RUNNERS);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Could not load class org.jboss.arquillian.container.test.spi.util.TestRunners");
            }
            Method getTestRunnerMethod = testRunnersClass.getMethod(METHOD_NAME_GET_TEST_RUNNER, ClassLoader.class);
            Object testRunner = getTestRunnerMethod.invoke(null, classLoader);
            Method executeMethod = testRunner.getClass().getMethod(METHOD_NAME_EXECUTE, Class.class, String.class);
            List setupActions = this.deploymentUnit.getAttachmentList(Attachments.SETUP_ACTIONS);
            ContextManager contextManager = new ContextManager(setupActions);
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                contextManager.setup(props);
                Serializable serializable = (Serializable)executeMethod.invoke(testRunner, testClass, methodName);
                contextManager.teardown(props);
                return serializable;
            }
            catch (Throwable throwable) {
                try {
                    contextManager.teardown(props);
                    throw throwable;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException iae) {
                    throw new RuntimeException(iae);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

