/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.daemon.protocol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;

public enum DaemonDeploymentPackager implements DeploymentPackager
{
    INSTANCE;

    private static final Logger log;

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive archive = testDeployment.getApplicationArchive();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive before additional packaging: " + archive.toString(true));
        }
        if (Validate.isArchiveOfType(WebArchive.class, (Archive)archive)) {
            ((LibraryContainer)archive).addAsLibraries(testDeployment.getAuxiliaryArchives());
        } else {
            this.mergeAuxAsClasses(archive, testDeployment);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive after additional packaging: " + archive.toString(true));
        }
        return archive;
    }

    private void mergeAuxAsClasses(Archive<?> archive, TestDeployment testDeployment) {
        HashMap<ArchivePath, List<Node>> serviceDescriptors = new HashMap<ArchivePath, List<Node>>();
        this.findServiceDescriptors(archive, serviceDescriptors);
        testDeployment.getAuxiliaryArchives().forEach(aux -> {
            this.findServiceDescriptors((Archive<?>)aux, (Map<ArchivePath, List<Node>>)serviceDescriptors);
            archive.merge(aux);
        });
        this.mergeServiceDescriptors(serviceDescriptors).forEach((path, asset) -> archive.add(asset, path));
    }

    private Map<ArchivePath, Asset> mergeServiceDescriptors(Map<ArchivePath, List<Node>> descs) {
        return descs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mergeServiceDescriptors((List)entry.getValue())));
    }

    private Asset mergeServiceDescriptors(List<Node> descs) {
        ArrayList lines = new ArrayList();
        descs.forEach(n -> {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(n.getAsset().openStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return new ServiceProviderAsset(lines.toArray(new String[lines.size()]));
    }

    private void findServiceDescriptors(Archive<?> archive, Map<ArchivePath, List<Node>> descs) {
        archive.getContent(path -> path.get().startsWith("/META-INF/services/")).forEach((path, node) -> {
            ArrayList<Node> nodes = (ArrayList<Node>)descs.get(path);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                descs.put((ArchivePath)path, (List<Node>)nodes);
            }
            nodes.add((Node)node);
        });
    }

    static {
        log = Logger.getLogger(DaemonDeploymentPackager.class.getName());
    }
}

