/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartException;
import org.wildfly.swarm.arquillian.daemon.server.Server;
import org.wildfly.swarm.arquillian.deployment.TestableArchiveService;

public class TestableArchiveServiceActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/arquillian-testable")));){
            List lines = reader.lines().collect(Collectors.toList());
            String archiveName = String.join((CharSequence)"", lines).trim();
            final TestableArchiveService testableArchiveService = new TestableArchiveService(archiveName);
            context.getServiceTarget().addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                    if (transition.enters(ServiceController.State.START_FAILED)) {
                        StartException exception = controller.getStartException();
                        Throwable cause = exception.getCause();
                        testableArchiveService.setError(cause);
                    }
                }
            });
            context.getServiceTarget().addService(TestableArchiveService.NAME, (Service)testableArchiveService).addDependency(ServiceName.of((String[])new String[]{"wildfly", "swarm", "arquillian", "daemon"}), Server.class, testableArchiveService.serverInjector).addDependency(Services.deploymentUnitName((String)archiveName), DeploymentUnit.class, testableArchiveService.deploymentUnitInjector).addDependency(Services.deploymentUnitName((String)archiveName, (Phase)Phase.POST_MODULE)).install();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

