/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.jboss.modules.IterableModuleFinder;
import org.jboss.modules.JDKModuleFinder;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Version;

public final class JDKModuleFinder
implements IterableModuleFinder {
    private final ModuleLayer layer = ModuleLayer.boot();
    private static final JDKModuleFinder INSTANCE = new JDKModuleFinder();

    private JDKModuleFinder() {
    }

    public static JDKModuleFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) {
        Set<String> packages;
        Module module;
        if ("org.jboss.modules".equals(name)) {
            module = this.getClass().getModule();
            packages = module.isNamed() ? module.getPackages() : Set.of("org.jboss.modules", "org.jboss.modules.filter", "org.jboss.modules.log", "org.jboss.modules.management", "org.jboss.modules.maven", "org.jboss.modules.ref", "org.jboss.modules.security", "org.jboss.modules.xml");
        } else {
            Optional<Module> moduleOptional = this.layer.findModule(name);
            if (!moduleOptional.isPresent()) {
                return null;
            }
            module = moduleOptional.get();
            packages = module.getPackages();
        }
        ModuleSpec.Builder builder = ModuleSpec.build(name);
        ModuleDescriptor descriptor = module.getDescriptor();
        if (descriptor != null) {
            Optional<String> version = descriptor.rawVersion();
            if (version.isPresent()) {
                builder.setVersion(Version.parse(version.get()));
            }
            for (ModuleDescriptor.Requires require : descriptor.requires()) {
                Set<ModuleDescriptor.Requires.Modifier> modifiers = require.modifiers();
                builder.addDependency(new ModuleDependencySpecBuilder().setName(require.name()).setExport(modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).setOptional(modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)).build());
            }
        }
        HashSet<String> paths = new HashSet<String>(packages.size());
        for (String pkg : packages) {
            paths.add(pkg.replace('.', '/'));
        }
        LocalDependencySpecBuilder depBuilder = new LocalDependencySpecBuilder();
        depBuilder.setLoaderPaths(paths);
        depBuilder.setExport(true);
        depBuilder.setLocalLoader((LocalLoader)new JDKModuleLoader(module, packages));
        builder.addDependency(depBuilder.build());
        return builder.create();
    }

    public String toString() {
        return "JDK Module Finder";
    }

    @Override
    public Iterator<String> iterateModules(String baseName, boolean recursive) {
        Set<Module> moduleSet = this.layer.modules();
        ArrayList<String> nameList = new ArrayList<String>(moduleSet.size() + 1);
        Module ourModule = this.getClass().getModule();
        boolean foundUs = false;
        for (Module module : moduleSet) {
            if (module == ourModule) {
                foundUs = true;
            }
            nameList.add(module.getName());
        }
        if (!foundUs) {
            nameList.add("org.jboss.modules");
        }
        return nameList.iterator();
    }
}

