/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DependencyTree<T> {
    private Map<T, Set<T>> depTree = new LinkedHashMap<T, Set<T>>();

    public void add(T parent, T child) {
        Set children = this.depTree.computeIfAbsent(parent, p -> new LinkedHashSet());
        if (!child.equals(parent)) {
            children.add(child);
        }
    }

    public void add(T parent) {
        this.depTree.computeIfAbsent(parent, p -> new LinkedHashSet());
    }

    public Collection<T> getDirectDeps() {
        return this.depTree.keySet();
    }

    public boolean isDirectDep(T parent) {
        return this.depTree.containsKey(parent);
    }

    public Collection<T> getTransientDeps(T parent) {
        Set<T> deps = this.depTree.get(parent);
        if (null == deps) {
            throw new IllegalArgumentException("Unknown dependency " + parent);
        }
        return deps;
    }
}

