package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepositoryConsumer;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepositorySupplier;
import org.wildfly.swarm.config.batch.jberet.JDBCJobRepository;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.batch.jberet.ThreadFactoryConsumer;
import org.wildfly.swarm.config.batch.jberet.ThreadFactorySupplier;
import org.wildfly.swarm.config.batch.jberet.ThreadFactory;
import org.wildfly.swarm.config.batch.jberet.ThreadPoolConsumer;
import org.wildfly.swarm.config.batch.jberet.ThreadPoolSupplier;
import org.wildfly.swarm.config.batch.jberet.ThreadPool;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepositoryConsumer;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepositorySupplier;
import org.wildfly.swarm.config.batch.jberet.InMemoryJobRepository;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Batch Subsystem (JSR-352)
 */
@Address("/subsystem=batch-jberet")
@ResourceType("subsystem")
@Implicit
public class BatchJBeret<T extends BatchJBeret<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private BatchJBeretResources subresources = new BatchJBeretResources();
	@AttributeDocumentation("The name of the default job repository.")
	private String defaultJobRepository;
	@AttributeDocumentation("The name of the default thread-pool.")
	private String defaultThreadPool;
	@AttributeDocumentation("If set to true when a resume operation has be invoked after a suspend operation any jobs stopped during the suspend will be restarted. A value of false will leave the jobs in a stopped state.")
	private Boolean restartJobsOnResume;
	@AttributeDocumentation("References the security domain for batch jobs. This can only be defined if the Elytron subsystem is available.")
	private String securityDomain;

	public BatchJBeret() {
		super();
		this.key = "batch-jberet";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public BatchJBeretResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all JDBCJobRepository objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JDBCJobRepository objects.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcJobRepositories(java.util.List<JDBCJobRepository> value) {
		this.subresources.jdbcJobRepositories = value;
		return (T) this;
	}

	/**
	 * Add the JDBCJobRepository object to the list of subresources
	 * 
	 * @param value
	 *            The JDBCJobRepository to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcJobRepository(JDBCJobRepository value) {
		this.subresources.jdbcJobRepositories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JDBCJobRepository object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the JDBCJobRepository resource
	 * @param config
	 *            The JDBCJobRepositoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcJobRepository(java.lang.String childKey,
			JDBCJobRepositoryConsumer consumer) {
		JDBCJobRepository<? extends JDBCJobRepository> child = new JDBCJobRepository<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jdbcJobRepository(child);
		return (T) this;
	}

	/**
	 * Create and configure a JDBCJobRepository object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the JDBCJobRepository resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcJobRepository(java.lang.String childKey) {
		jdbcJobRepository(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JDBCJobRepository object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jdbcJobRepository(JDBCJobRepositorySupplier supplier) {
		jdbcJobRepository(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ThreadFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ThreadFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T threadFactories(java.util.List<ThreadFactory> value) {
		this.subresources.threadFactories = value;
		return (T) this;
	}

	/**
	 * Add the ThreadFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ThreadFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(ThreadFactory value) {
		this.subresources.threadFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadFactory object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadFactory resource
	 * @param config
	 *            The ThreadFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(java.lang.String childKey,
			ThreadFactoryConsumer consumer) {
		ThreadFactory<? extends ThreadFactory> child = new ThreadFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		threadFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadFactory object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(java.lang.String childKey) {
		threadFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ThreadFactory object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(ThreadFactorySupplier supplier) {
		threadFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ThreadPool objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ThreadPool objects.
	 */
	@SuppressWarnings("unchecked")
	public T threadPools(java.util.List<ThreadPool> value) {
		this.subresources.threadPools = value;
		return (T) this;
	}

	/**
	 * Add the ThreadPool object to the list of subresources
	 * 
	 * @param value
	 *            The ThreadPool to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(ThreadPool value) {
		this.subresources.threadPools.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadPool object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadPool resource
	 * @param config
	 *            The ThreadPoolConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(java.lang.String childKey, ThreadPoolConsumer consumer) {
		ThreadPool<? extends ThreadPool> child = new ThreadPool<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		threadPool(child);
		return (T) this;
	}

	/**
	 * Create and configure a ThreadPool object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ThreadPool resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(java.lang.String childKey) {
		threadPool(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ThreadPool object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T threadPool(ThreadPoolSupplier supplier) {
		threadPool(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InMemoryJobRepository objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InMemoryJobRepository objects.
	 */
	@SuppressWarnings("unchecked")
	public T inMemoryJobRepositories(java.util.List<InMemoryJobRepository> value) {
		this.subresources.inMemoryJobRepositories = value;
		return (T) this;
	}

	/**
	 * Add the InMemoryJobRepository object to the list of subresources
	 * 
	 * @param value
	 *            The InMemoryJobRepository to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inMemoryJobRepository(InMemoryJobRepository value) {
		this.subresources.inMemoryJobRepositories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InMemoryJobRepository object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the InMemoryJobRepository resource
	 * @param config
	 *            The InMemoryJobRepositoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inMemoryJobRepository(java.lang.String childKey,
			InMemoryJobRepositoryConsumer consumer) {
		InMemoryJobRepository<? extends InMemoryJobRepository> child = new InMemoryJobRepository<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inMemoryJobRepository(child);
		return (T) this;
	}

	/**
	 * Create and configure a InMemoryJobRepository object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the InMemoryJobRepository resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inMemoryJobRepository(java.lang.String childKey) {
		inMemoryJobRepository(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InMemoryJobRepository object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T inMemoryJobRepository(InMemoryJobRepositorySupplier supplier) {
		inMemoryJobRepository(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for BatchJBeret
	 */
	public static class BatchJBeretResources {
		/**
		 * A job repository that stores job information in a database.
		 */
		@ResourceDocumentation("A job repository that stores job information in a database.")
		@SubresourceInfo("jdbcJobRepository")
		private List<JDBCJobRepository> jdbcJobRepositories = new java.util.ArrayList<>();
		/**
		 * A thread factory (implementing java.util.concurrent.ThreadFactory).
		 */
		@ResourceDocumentation("A thread factory (implementing java.util.concurrent.ThreadFactory).")
		@SubresourceInfo("threadFactory")
		private List<ThreadFactory> threadFactories = new java.util.ArrayList<>();
		/**
		 * The thread pool used for batch jobs. Note that the max-thread
		 * attribute should always be greater than 3. Two threads are reserved
		 * to ensure partition jobs can execute.
		 */
		@ResourceDocumentation("The thread pool used for batch jobs. Note that the max-thread attribute should always be greater than 3. Two threads are reserved to ensure partition jobs can execute.")
		@SubresourceInfo("threadPool")
		private List<ThreadPool> threadPools = new java.util.ArrayList<>();
		/**
		 * A job repository that stores job information in memory.
		 */
		@ResourceDocumentation("A job repository that stores job information in memory.")
		@SubresourceInfo("inMemoryJobRepository")
		private List<InMemoryJobRepository> inMemoryJobRepositories = new java.util.ArrayList<>();

		/**
		 * Get the list of JDBCJobRepository resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JDBCJobRepository> jdbcJobRepositories() {
			return this.jdbcJobRepositories;
		}

		public JDBCJobRepository jdbcJobRepository(java.lang.String key) {
			return this.jdbcJobRepositories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ThreadFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ThreadFactory> threadFactories() {
			return this.threadFactories;
		}

		public ThreadFactory threadFactory(java.lang.String key) {
			return this.threadFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ThreadPool resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ThreadPool> threadPools() {
			return this.threadPools;
		}

		public ThreadPool threadPool(java.lang.String key) {
			return this.threadPools.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of InMemoryJobRepository resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InMemoryJobRepository> inMemoryJobRepositories() {
			return this.inMemoryJobRepositories;
		}

		public InMemoryJobRepository inMemoryJobRepository(java.lang.String key) {
			return this.inMemoryJobRepositories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The name of the default job repository.
	 */
	@ModelNodeBinding(detypedName = "default-job-repository")
	public String defaultJobRepository() {
		return this.defaultJobRepository;
	}

	/**
	 * The name of the default job repository.
	 */
	@SuppressWarnings("unchecked")
	public T defaultJobRepository(java.lang.String value) {
		Object oldValue = this.defaultJobRepository;
		this.defaultJobRepository = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultJobRepository", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the default thread-pool.
	 */
	@ModelNodeBinding(detypedName = "default-thread-pool")
	public String defaultThreadPool() {
		return this.defaultThreadPool;
	}

	/**
	 * The name of the default thread-pool.
	 */
	@SuppressWarnings("unchecked")
	public T defaultThreadPool(java.lang.String value) {
		Object oldValue = this.defaultThreadPool;
		this.defaultThreadPool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultThreadPool", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true when a resume operation has be invoked after a suspend
	 * operation any jobs stopped during the suspend will be restarted. A value
	 * of false will leave the jobs in a stopped state.
	 */
	@ModelNodeBinding(detypedName = "restart-jobs-on-resume")
	public Boolean restartJobsOnResume() {
		return this.restartJobsOnResume;
	}

	/**
	 * If set to true when a resume operation has be invoked after a suspend
	 * operation any jobs stopped during the suspend will be restarted. A value
	 * of false will leave the jobs in a stopped state.
	 */
	@SuppressWarnings("unchecked")
	public T restartJobsOnResume(java.lang.Boolean value) {
		Object oldValue = this.restartJobsOnResume;
		this.restartJobsOnResume = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("restartJobsOnResume", oldValue, value);
		return (T) this;
	}

	/**
	 * References the security domain for batch jobs. This can only be defined
	 * if the Elytron subsystem is available.
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * References the security domain for batch jobs. This can only be defined
	 * if the Elytron subsystem is available.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}
}