package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.deployment.scanner.ScannerConsumer;
import org.wildfly.swarm.config.deployment.scanner.ScannerSupplier;
import org.wildfly.swarm.config.deployment.scanner.Scanner;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * An individual deployment scanner that scans a particular location
 */
@Address("/subsystem=deployment-scanner")
@ResourceType("subsystem")
@Implicit
public class DeploymentScanner<T extends DeploymentScanner<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private DeploymentScannerResources subresources = new DeploymentScannerResources();

	public DeploymentScanner() {
		super();
		this.key = "deployment-scanner";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public DeploymentScannerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Scanner objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Scanner objects.
	 */
	@SuppressWarnings("unchecked")
	public T scanners(java.util.List<Scanner> value) {
		this.subresources.scanners = value;
		return (T) this;
	}

	/**
	 * Add the Scanner object to the list of subresources
	 * 
	 * @param value
	 *            The Scanner to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T scanner(Scanner value) {
		this.subresources.scanners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Scanner object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Scanner resource
	 * @param config
	 *            The ScannerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T scanner(java.lang.String childKey, ScannerConsumer consumer) {
		Scanner<? extends Scanner> child = new Scanner<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		scanner(child);
		return (T) this;
	}

	/**
	 * Create and configure a Scanner object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Scanner resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T scanner(java.lang.String childKey) {
		scanner(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Scanner object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T scanner(ScannerSupplier supplier) {
		scanner(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for DeploymentScanner
	 */
	public static class DeploymentScannerResources {
		/**
		 * The configuration of the deployment scanner subsystem
		 */
		@ResourceDocumentation("The configuration of the deployment scanner subsystem")
		@SubresourceInfo("scanner")
		private List<Scanner> scanners = new java.util.ArrayList<>();

		/**
		 * Get the list of Scanner resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Scanner> scanners() {
			return this.scanners;
		}

		public Scanner scanner(java.lang.String key) {
			return this.scanners.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}