package org.wildfly.swarm.config;

import org.wildfly.swarm.config.DeploymentScanner;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DeploymentScannerConsumer<T extends DeploymentScanner<T>> {

	/**
	 * Configure a pre-constructed instance of DeploymentScanner resource
	 * 
	 * @parameter Instance of DeploymentScanner to configure
	 * @return nothing
	 */
	void accept(T value);

	default DeploymentScannerConsumer<T> andThen(
			DeploymentScannerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}