package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.discovery.StaticProviderConsumer;
import org.wildfly.swarm.config.discovery.StaticProviderSupplier;
import org.wildfly.swarm.config.discovery.StaticProvider;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.discovery.AggregateProviderConsumer;
import org.wildfly.swarm.config.discovery.AggregateProviderSupplier;
import org.wildfly.swarm.config.discovery.AggregateProvider;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The discovery subsystem
 */
@Address("/subsystem=discovery")
@ResourceType("subsystem")
@Implicit
public class Discovery<T extends Discovery<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private DiscoveryResources subresources = new DiscoveryResources();

	public Discovery() {
		super();
		this.key = "discovery";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public DiscoveryResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all StaticProvider objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of StaticProvider objects.
	 */
	@SuppressWarnings("unchecked")
	public T staticProviders(java.util.List<StaticProvider> value) {
		this.subresources.staticProviders = value;
		return (T) this;
	}

	/**
	 * Add the StaticProvider object to the list of subresources
	 * 
	 * @param value
	 *            The StaticProvider to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T staticProvider(StaticProvider value) {
		this.subresources.staticProviders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a StaticProvider object to the list of subresources
	 * 
	 * @param key
	 *            The key for the StaticProvider resource
	 * @param config
	 *            The StaticProviderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T staticProvider(java.lang.String childKey,
			StaticProviderConsumer consumer) {
		StaticProvider<? extends StaticProvider> child = new StaticProvider<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		staticProvider(child);
		return (T) this;
	}

	/**
	 * Create and configure a StaticProvider object to the list of subresources
	 * 
	 * @param key
	 *            The key for the StaticProvider resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T staticProvider(java.lang.String childKey) {
		staticProvider(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied StaticProvider object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T staticProvider(StaticProviderSupplier supplier) {
		staticProvider(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AggregateProvider objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AggregateProvider objects.
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProviders(java.util.List<AggregateProvider> value) {
		this.subresources.aggregateProviders = value;
		return (T) this;
	}

	/**
	 * Add the AggregateProvider object to the list of subresources
	 * 
	 * @param value
	 *            The AggregateProvider to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProvider(AggregateProvider value) {
		this.subresources.aggregateProviders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateProvider object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateProvider resource
	 * @param config
	 *            The AggregateProviderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProvider(java.lang.String childKey,
			AggregateProviderConsumer consumer) {
		AggregateProvider<? extends AggregateProvider> child = new AggregateProvider<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		aggregateProvider(child);
		return (T) this;
	}

	/**
	 * Create and configure a AggregateProvider object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the AggregateProvider resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProvider(java.lang.String childKey) {
		aggregateProvider(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AggregateProvider object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T aggregateProvider(AggregateProviderSupplier supplier) {
		aggregateProvider(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Discovery
	 */
	public static class DiscoveryResources {
		/**
		 * A static discovery provider definition
		 */
		@ResourceDocumentation("A static discovery provider definition")
		@SubresourceInfo("staticProvider")
		private List<StaticProvider> staticProviders = new java.util.ArrayList<>();
		/**
		 * An aggregate discovery provider definition
		 */
		@ResourceDocumentation("An aggregate discovery provider definition")
		@SubresourceInfo("aggregateProvider")
		private List<AggregateProvider> aggregateProviders = new java.util.ArrayList<>();

		/**
		 * Get the list of StaticProvider resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<StaticProvider> staticProviders() {
			return this.staticProviders;
		}

		public StaticProvider staticProvider(java.lang.String key) {
			return this.staticProviders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AggregateProvider resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AggregateProvider> aggregateProviders() {
			return this.aggregateProviders;
		}

		public AggregateProvider aggregateProvider(java.lang.String key) {
			return this.aggregateProviders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}