package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Discovery;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DiscoveryConsumer<T extends Discovery<T>> {

	/**
	 * Configure a pre-constructed instance of Discovery resource
	 * 
	 * @parameter Instance of Discovery to configure
	 * @return nothing
	 */
	void accept(T value);

	default DiscoveryConsumer<T> andThen(DiscoveryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}