package org.wildfly.swarm.config;

import org.wildfly.swarm.config.EESecurity;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface EESecurityConsumer<T extends EESecurity<T>> {

	/**
	 * Configure a pre-constructed instance of EESecurity resource
	 * 
	 * @parameter Instance of EESecurity to configure
	 * @return nothing
	 */
	void accept(T value);

	default EESecurityConsumer<T> andThen(EESecurityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}