package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.CacheContainerConsumer;
import org.wildfly.swarm.config.infinispan.CacheContainerSupplier;
import org.wildfly.swarm.config.infinispan.CacheContainer;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.infinispan.RemoteCacheContainerConsumer;
import org.wildfly.swarm.config.infinispan.RemoteCacheContainerSupplier;
import org.wildfly.swarm.config.infinispan.RemoteCacheContainer;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the infinispan subsystem.
 */
@Address("/subsystem=infinispan")
@ResourceType("subsystem")
@Implicit
public class Infinispan<T extends Infinispan<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private InfinispanResources subresources = new InfinispanResources();

	public Infinispan() {
		super();
		this.key = "infinispan";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public InfinispanResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all CacheContainer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CacheContainer objects.
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainers(java.util.List<CacheContainer> value) {
		this.subresources.cacheContainers = value;
		return (T) this;
	}

	/**
	 * Add the CacheContainer object to the list of subresources
	 * 
	 * @param value
	 *            The CacheContainer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(CacheContainer value) {
		this.subresources.cacheContainers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CacheContainer object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CacheContainer resource
	 * @param config
	 *            The CacheContainerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(java.lang.String childKey,
			CacheContainerConsumer consumer) {
		CacheContainer<? extends CacheContainer> child = new CacheContainer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		cacheContainer(child);
		return (T) this;
	}

	/**
	 * Create and configure a CacheContainer object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CacheContainer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(java.lang.String childKey) {
		cacheContainer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CacheContainer object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(CacheContainerSupplier supplier) {
		cacheContainer(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteCacheContainer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteCacheContainer objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCacheContainers(java.util.List<RemoteCacheContainer> value) {
		this.subresources.remoteCacheContainers = value;
		return (T) this;
	}

	/**
	 * Add the RemoteCacheContainer object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteCacheContainer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCacheContainer(RemoteCacheContainer value) {
		this.subresources.remoteCacheContainers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCacheContainer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RemoteCacheContainer resource
	 * @param config
	 *            The RemoteCacheContainerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCacheContainer(java.lang.String childKey,
			RemoteCacheContainerConsumer consumer) {
		RemoteCacheContainer<? extends RemoteCacheContainer> child = new RemoteCacheContainer<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteCacheContainer(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCacheContainer object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RemoteCacheContainer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCacheContainer(java.lang.String childKey) {
		remoteCacheContainer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteCacheContainer object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteCacheContainer(RemoteCacheContainerSupplier supplier) {
		remoteCacheContainer(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Infinispan
	 */
	public static class InfinispanResources {
		/**
		 * The configuration of an infinispan cache container
		 */
		@ResourceDocumentation("The configuration of an infinispan cache container")
		@SubresourceInfo("cacheContainer")
		private List<CacheContainer> cacheContainers = new java.util.ArrayList<>();
		/**
		 * The configuration of a remote Infinispan cache container.
		 */
		@ResourceDocumentation("The configuration of a remote Infinispan cache container.")
		@SubresourceInfo("remoteCacheContainer")
		private List<RemoteCacheContainer> remoteCacheContainers = new java.util.ArrayList<>();

		/**
		 * Get the list of CacheContainer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CacheContainer> cacheContainers() {
			return this.cacheContainers;
		}

		public CacheContainer cacheContainer(java.lang.String key) {
			return this.cacheContainers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteCacheContainer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteCacheContainer> remoteCacheContainers() {
			return this.remoteCacheContainers;
		}

		public RemoteCacheContainer remoteCacheContainer(java.lang.String key) {
			return this.remoteCacheContainers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}