package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.SecurityRealmConsumer;
import org.wildfly.swarm.config.management.SecurityRealmSupplier;
import org.wildfly.swarm.config.management.SecurityRealm;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.management.LdapConnectionConsumer;
import org.wildfly.swarm.config.management.LdapConnectionSupplier;
import org.wildfly.swarm.config.management.LdapConnection;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterface;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.NativeRemotingInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.AuditAccess;
import org.wildfly.swarm.config.management.AuditAccessConsumer;
import org.wildfly.swarm.config.management.AuditAccessSupplier;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterface;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.NativeInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.ManagementOperationsService;
import org.wildfly.swarm.config.management.ManagementOperationsServiceConsumer;
import org.wildfly.swarm.config.management.ManagementOperationsServiceSupplier;
import org.wildfly.swarm.config.management.ConfigurationChangesService;
import org.wildfly.swarm.config.management.ConfigurationChangesServiceConsumer;
import org.wildfly.swarm.config.management.ConfigurationChangesServiceSupplier;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterface;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceSupplier;
import org.wildfly.swarm.config.management.IdentityAccess;
import org.wildfly.swarm.config.management.IdentityAccessConsumer;
import org.wildfly.swarm.config.management.IdentityAccessSupplier;
import org.wildfly.swarm.config.management.AuthorizationAccess;
import org.wildfly.swarm.config.management.AuthorizationAccessConsumer;
import org.wildfly.swarm.config.management.AuthorizationAccessSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The management services used to control a server or a host's host controller.
 */
@Address("/core-service=management")
@ResourceType("core-service")
@Implicit
public class ManagementCoreService<T extends ManagementCoreService<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ManagementCoreServiceResources subresources = new ManagementCoreServiceResources();

	public ManagementCoreService() {
		super();
		this.key = "management";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ManagementCoreServiceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all SecurityRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecurityRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealms(java.util.List<SecurityRealm> value) {
		this.subresources.securityRealms = value;
		return (T) this;
	}

	/**
	 * Add the SecurityRealm object to the list of subresources
	 * 
	 * @param value
	 *            The SecurityRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(SecurityRealm value) {
		this.subresources.securityRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityRealm resource
	 * @param config
	 *            The SecurityRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String childKey,
			SecurityRealmConsumer consumer) {
		SecurityRealm<? extends SecurityRealm> child = new SecurityRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		securityRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String childKey) {
		securityRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecurityRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(SecurityRealmSupplier supplier) {
		securityRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LdapConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LdapConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T ldapConnections(java.util.List<LdapConnection> value) {
		this.subresources.ldapConnections = value;
		return (T) this;
	}

	/**
	 * Add the LdapConnection object to the list of subresources
	 * 
	 * @param value
	 *            The LdapConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapConnection(LdapConnection value) {
		this.subresources.ldapConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LdapConnection object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapConnection resource
	 * @param config
	 *            The LdapConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapConnection(java.lang.String childKey,
			LdapConnectionConsumer consumer) {
		LdapConnection<? extends LdapConnection> child = new LdapConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		ldapConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a LdapConnection object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LdapConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ldapConnection(java.lang.String childKey) {
		ldapConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LdapConnection object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T ldapConnection(LdapConnectionSupplier supplier) {
		ldapConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface using a
	 * connector from the remoting subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T nativeRemotingInterfaceManagementInterface(
			NativeRemotingInterfaceManagementInterface value) {
		this.subresources.nativeRemotingInterfaceManagementInterface = value;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface using a
	 * connector from the remoting subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T nativeRemotingInterfaceManagementInterface(
			NativeRemotingInterfaceManagementInterfaceConsumer consumer) {
		NativeRemotingInterfaceManagementInterface<? extends NativeRemotingInterfaceManagementInterface> child = new NativeRemotingInterfaceManagementInterface<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.nativeRemotingInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface using a
	 * connector from the remoting subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T nativeRemotingInterfaceManagementInterface() {
		NativeRemotingInterfaceManagementInterface<? extends NativeRemotingInterfaceManagementInterface> child = new NativeRemotingInterfaceManagementInterface<>();
		this.subresources.nativeRemotingInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface using a
	 * connector from the remoting subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T nativeRemotingInterfaceManagementInterface(
			NativeRemotingInterfaceManagementInterfaceSupplier supplier) {
		this.subresources.nativeRemotingInterfaceManagementInterface = supplier
				.get();
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditAccess(AuditAccess value) {
		this.subresources.auditAccess = value;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditAccess(AuditAccessConsumer consumer) {
		AuditAccess<? extends AuditAccess> child = new AuditAccess<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.auditAccess = child;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditAccess() {
		AuditAccess<? extends AuditAccess> child = new AuditAccess<>();
		this.subresources.auditAccess = child;
		return (T) this;
	}

	/**
	 * The management audit logging top-level resource.
	 */
	@SuppressWarnings("unchecked")
	public T auditAccess(AuditAccessSupplier supplier) {
		this.subresources.auditAccess = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface
	 */
	@SuppressWarnings("unchecked")
	public T nativeInterfaceManagementInterface(
			NativeInterfaceManagementInterface value) {
		this.subresources.nativeInterfaceManagementInterface = value;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface
	 */
	@SuppressWarnings("unchecked")
	public T nativeInterfaceManagementInterface(
			NativeInterfaceManagementInterfaceConsumer consumer) {
		NativeInterfaceManagementInterface<? extends NativeInterfaceManagementInterface> child = new NativeInterfaceManagementInterface<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.nativeInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface
	 */
	@SuppressWarnings("unchecked")
	public T nativeInterfaceManagementInterface() {
		NativeInterfaceManagementInterface<? extends NativeInterfaceManagementInterface> child = new NativeInterfaceManagementInterface<>();
		this.subresources.nativeInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's native management interface
	 */
	@SuppressWarnings("unchecked")
	public T nativeInterfaceManagementInterface(
			NativeInterfaceManagementInterfaceSupplier supplier) {
		this.subresources.nativeInterfaceManagementInterface = supplier.get();
		return (T) this;
	}

	/**
	 * Execution of management operations.
	 */
	@SuppressWarnings("unchecked")
	public T managementOperationsService(ManagementOperationsService value) {
		this.subresources.managementOperationsService = value;
		return (T) this;
	}

	/**
	 * Execution of management operations.
	 */
	@SuppressWarnings("unchecked")
	public T managementOperationsService(
			ManagementOperationsServiceConsumer consumer) {
		ManagementOperationsService<? extends ManagementOperationsService> child = new ManagementOperationsService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.managementOperationsService = child;
		return (T) this;
	}

	/**
	 * Execution of management operations.
	 */
	@SuppressWarnings("unchecked")
	public T managementOperationsService() {
		ManagementOperationsService<? extends ManagementOperationsService> child = new ManagementOperationsService<>();
		this.subresources.managementOperationsService = child;
		return (T) this;
	}

	/**
	 * Execution of management operations.
	 */
	@SuppressWarnings("unchecked")
	public T managementOperationsService(
			ManagementOperationsServiceSupplier supplier) {
		this.subresources.managementOperationsService = supplier.get();
		return (T) this;
	}

	/**
	 * Service to store and list configuration changes.
	 */
	@SuppressWarnings("unchecked")
	public T configurationChangesService(ConfigurationChangesService value) {
		this.subresources.configurationChangesService = value;
		return (T) this;
	}

	/**
	 * Service to store and list configuration changes.
	 */
	@SuppressWarnings("unchecked")
	public T configurationChangesService(
			ConfigurationChangesServiceConsumer consumer) {
		ConfigurationChangesService<? extends ConfigurationChangesService> child = new ConfigurationChangesService<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.configurationChangesService = child;
		return (T) this;
	}

	/**
	 * Service to store and list configuration changes.
	 */
	@SuppressWarnings("unchecked")
	public T configurationChangesService() {
		ConfigurationChangesService<? extends ConfigurationChangesService> child = new ConfigurationChangesService<>();
		this.subresources.configurationChangesService = child;
		return (T) this;
	}

	/**
	 * Service to store and list configuration changes.
	 */
	@SuppressWarnings("unchecked")
	public T configurationChangesService(
			ConfigurationChangesServiceSupplier supplier) {
		this.subresources.configurationChangesService = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration of the server's HTTP management interface
	 */
	@SuppressWarnings("unchecked")
	public T httpInterfaceManagementInterface(
			HTTPInterfaceManagementInterface value) {
		this.subresources.httpInterfaceManagementInterface = value;
		return (T) this;
	}

	/**
	 * Configuration of the server's HTTP management interface
	 */
	@SuppressWarnings("unchecked")
	public T httpInterfaceManagementInterface(
			HTTPInterfaceManagementInterfaceConsumer consumer) {
		HTTPInterfaceManagementInterface<? extends HTTPInterfaceManagementInterface> child = new HTTPInterfaceManagementInterface<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.httpInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's HTTP management interface
	 */
	@SuppressWarnings("unchecked")
	public T httpInterfaceManagementInterface() {
		HTTPInterfaceManagementInterface<? extends HTTPInterfaceManagementInterface> child = new HTTPInterfaceManagementInterface<>();
		this.subresources.httpInterfaceManagementInterface = child;
		return (T) this;
	}

	/**
	 * Configuration of the server's HTTP management interface
	 */
	@SuppressWarnings("unchecked")
	public T httpInterfaceManagementInterface(
			HTTPInterfaceManagementInterfaceSupplier supplier) {
		this.subresources.httpInterfaceManagementInterface = supplier.get();
		return (T) this;
	}

	/**
	 * Identity definition for management actions.
	 */
	@SuppressWarnings("unchecked")
	public T identityAccess(IdentityAccess value) {
		this.subresources.identityAccess = value;
		return (T) this;
	}

	/**
	 * Identity definition for management actions.
	 */
	@SuppressWarnings("unchecked")
	public T identityAccess(IdentityAccessConsumer consumer) {
		IdentityAccess<? extends IdentityAccess> child = new IdentityAccess<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.identityAccess = child;
		return (T) this;
	}

	/**
	 * Identity definition for management actions.
	 */
	@SuppressWarnings("unchecked")
	public T identityAccess() {
		IdentityAccess<? extends IdentityAccess> child = new IdentityAccess<>();
		this.subresources.identityAccess = child;
		return (T) this;
	}

	/**
	 * Identity definition for management actions.
	 */
	@SuppressWarnings("unchecked")
	public T identityAccess(IdentityAccessSupplier supplier) {
		this.subresources.identityAccess = supplier.get();
		return (T) this;
	}

	/**
	 * The access control definitions defining the access management
	 * restrictions.
	 */
	@SuppressWarnings("unchecked")
	public T authorizationAccess(AuthorizationAccess value) {
		this.subresources.authorizationAccess = value;
		return (T) this;
	}

	/**
	 * The access control definitions defining the access management
	 * restrictions.
	 */
	@SuppressWarnings("unchecked")
	public T authorizationAccess(AuthorizationAccessConsumer consumer) {
		AuthorizationAccess<? extends AuthorizationAccess> child = new AuthorizationAccess<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.authorizationAccess = child;
		return (T) this;
	}

	/**
	 * The access control definitions defining the access management
	 * restrictions.
	 */
	@SuppressWarnings("unchecked")
	public T authorizationAccess() {
		AuthorizationAccess<? extends AuthorizationAccess> child = new AuthorizationAccess<>();
		this.subresources.authorizationAccess = child;
		return (T) this;
	}

	/**
	 * The access control definitions defining the access management
	 * restrictions.
	 */
	@SuppressWarnings("unchecked")
	public T authorizationAccess(AuthorizationAccessSupplier supplier) {
		this.subresources.authorizationAccess = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for ManagementCoreService
	 */
	public static class ManagementCoreServiceResources {
		/**
		 * A security realm that can be associated with a management interface
		 * and used to control access to the management services.
		 */
		@ResourceDocumentation("A security realm that can be associated with a management interface and used to control access to the management services.")
		@SubresourceInfo("securityRealm")
		private List<SecurityRealm> securityRealms = new java.util.ArrayList<>();
		/**
		 * A connection factory that can be used by a security realm to access
		 * an LDAP server as a source of authentication and authorization
		 * information.
		 */
		@ResourceDocumentation("A connection factory that can be used by a security realm to access an LDAP server as a source of authentication and authorization information.")
		@SubresourceInfo("ldapConnection")
		private List<LdapConnection> ldapConnections = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("Configuration of the server's native management interface using a connector from the remoting subsystem.")
		private NativeRemotingInterfaceManagementInterface nativeRemotingInterfaceManagementInterface;
		@SingletonResource
		@ResourceDocumentation("The management audit logging top-level resource.")
		private AuditAccess auditAccess;
		@SingletonResource
		@ResourceDocumentation("Configuration of the server's native management interface")
		private NativeInterfaceManagementInterface nativeInterfaceManagementInterface;
		@SingletonResource
		@ResourceDocumentation("Execution of management operations.")
		private ManagementOperationsService managementOperationsService;
		@SingletonResource
		@ResourceDocumentation("Service to store and list configuration changes.")
		private ConfigurationChangesService configurationChangesService;
		@SingletonResource
		@ResourceDocumentation("Configuration of the server's HTTP management interface")
		private HTTPInterfaceManagementInterface httpInterfaceManagementInterface;
		@SingletonResource
		@ResourceDocumentation("Identity definition for management actions.")
		private IdentityAccess identityAccess;
		@SingletonResource
		@ResourceDocumentation("The access control definitions defining the access management restrictions.")
		private AuthorizationAccess authorizationAccess;

		/**
		 * Get the list of SecurityRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecurityRealm> securityRealms() {
			return this.securityRealms;
		}

		public SecurityRealm securityRealm(java.lang.String key) {
			return this.securityRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LdapConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LdapConnection> ldapConnections() {
			return this.ldapConnections;
		}

		public LdapConnection ldapConnection(java.lang.String key) {
			return this.ldapConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Configuration of the server's native management interface using a
		 * connector from the remoting subsystem.
		 */
		@Subresource
		public NativeRemotingInterfaceManagementInterface nativeRemotingInterfaceManagementInterface() {
			return this.nativeRemotingInterfaceManagementInterface;
		}

		/**
		 * The management audit logging top-level resource.
		 */
		@Subresource
		public AuditAccess auditAccess() {
			return this.auditAccess;
		}

		/**
		 * Configuration of the server's native management interface
		 */
		@Subresource
		public NativeInterfaceManagementInterface nativeInterfaceManagementInterface() {
			return this.nativeInterfaceManagementInterface;
		}

		/**
		 * Execution of management operations.
		 */
		@Subresource
		public ManagementOperationsService managementOperationsService() {
			return this.managementOperationsService;
		}

		/**
		 * Service to store and list configuration changes.
		 */
		@Subresource
		public ConfigurationChangesService configurationChangesService() {
			return this.configurationChangesService;
		}

		/**
		 * Configuration of the server's HTTP management interface
		 */
		@Subresource
		public HTTPInterfaceManagementInterface httpInterfaceManagementInterface() {
			return this.httpInterfaceManagementInterface;
		}

		/**
		 * Identity definition for management actions.
		 */
		@Subresource
		public IdentityAccess identityAccess() {
			return this.identityAccess;
		}

		/**
		 * The access control definitions defining the access management
		 * restrictions.
		 */
		@Subresource
		public AuthorizationAccess authorizationAccess() {
			return this.authorizationAccess;
		}
	}
}