package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.modcluster.ProxyConsumer;
import org.wildfly.swarm.config.modcluster.ProxySupplier;
import org.wildfly.swarm.config.modcluster.Proxy;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration and runtime operations for mod_cluster subsystem.
 */
@Address("/subsystem=modcluster")
@ResourceType("subsystem")
@Implicit
public class Modcluster<T extends Modcluster<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ModclusterResources subresources = new ModclusterResources();

	public Modcluster() {
		super();
		this.key = "modcluster";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ModclusterResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Proxy objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Proxy objects.
	 */
	@SuppressWarnings("unchecked")
	public T proxies(java.util.List<Proxy> value) {
		this.subresources.proxies = value;
		return (T) this;
	}

	/**
	 * Add the Proxy object to the list of subresources
	 * 
	 * @param value
	 *            The Proxy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T proxy(Proxy value) {
		this.subresources.proxies.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Proxy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Proxy resource
	 * @param config
	 *            The ProxyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T proxy(java.lang.String childKey, ProxyConsumer consumer) {
		Proxy<? extends Proxy> child = new Proxy<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		proxy(child);
		return (T) this;
	}

	/**
	 * Create and configure a Proxy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Proxy resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T proxy(java.lang.String childKey) {
		proxy(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Proxy object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T proxy(ProxySupplier supplier) {
		proxy(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Modcluster
	 */
	public static class ModclusterResources {
		/**
		 * Proxy resource coupled with single Undertow listener (and server)
		 * specifying load balancer discovery, its configuration and load
		 * balance factor provider. Multiple proxy configuration can be
		 * specified.
		 */
		@ResourceDocumentation("Proxy resource coupled with single Undertow listener (and server) specifying load balancer discovery, its configuration and load balance factor provider. Multiple proxy configuration can be specified.")
		@SubresourceInfo("proxy")
		private List<Proxy> proxies = new java.util.ArrayList<>();

		/**
		 * Get the list of Proxy resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Proxy> proxies() {
			return this.proxies;
		}

		public Proxy proxy(java.lang.String key) {
			return this.proxies.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}