package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.HTTPConnectorConsumer;
import org.wildfly.swarm.config.remoting.HTTPConnectorSupplier;
import org.wildfly.swarm.config.remoting.HTTPConnector;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.remoting.ConnectorConsumer;
import org.wildfly.swarm.config.remoting.ConnectorSupplier;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.OutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.OutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConsumer;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionSupplier;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.EndpointConfigurationConsumer;
import org.wildfly.swarm.config.remoting.EndpointConfigurationSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the Remoting subsystem.
 */
@Address("/subsystem=remoting")
@ResourceType("subsystem")
@Implicit
public class Remoting<T extends Remoting<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private RemotingResources subresources = new RemotingResources();
	@AttributeDocumentation("The authentication realm to use if no authentication CallbackHandler is specified.")
	private String authRealm;
	@AttributeDocumentation("Specify the number of times a client is allowed to retry authentication before closing the connection.")
	private Integer authenticationRetries;
	@AttributeDocumentation("The SASL authorization ID.  Used as authentication user name to use if no authentication CallbackHandler is specified and the selected SASL mechanism demands a user name.")
	private String authorizeId;
	@AttributeDocumentation("The size of allocated buffer regions.")
	private Integer bufferRegionSize;
	@AttributeDocumentation("The interval to use for connection heartbeat, in milliseconds.  If the connection is idle in the outbound direction for this amount of time, a ping message will be sent, which will trigger a corresponding reply message.")
	private Integer heartbeatInterval;
	@AttributeDocumentation("The maximum number of inbound channels to support for a connection.")
	private Integer maxInboundChannels;
	@AttributeDocumentation("The maximum inbound message size to be allowed.  Messages exceeding this size will cause an exception to be thrown on the reading side as well as the writing side.")
	private Long maxInboundMessageSize;
	@AttributeDocumentation("The maximum number of concurrent inbound messages on a channel.")
	private Integer maxInboundMessages;
	@AttributeDocumentation("The maximum number of outbound channels to support for a connection.")
	private Integer maxOutboundChannels;
	@AttributeDocumentation("The maximum outbound message size to send.  No messages larger than this well be transmitted; attempting to do so will cause an exception on the writing side.")
	private Long maxOutboundMessageSize;
	@AttributeDocumentation("The maximum number of concurrent outbound messages on a channel.")
	private Integer maxOutboundMessages;
	@AttributeDocumentation("The size of the largest buffer that this endpoint will accept over a connection.")
	private Integer receiveBufferSize;
	@AttributeDocumentation("The maximum window size of the receive direction for connection channels, in bytes.")
	private Integer receiveWindowSize;
	@AttributeDocumentation("Where a SaslServer or SaslClient are created by default the protocol specified it 'remoting', this can be used to override this.")
	private String saslProtocol;
	@AttributeDocumentation("The size of the largest buffer that this endpoint will transmit over a connection.")
	private Integer sendBufferSize;
	@AttributeDocumentation("The server side of the connection passes it's name to the client in the initial greeting, by default the name is automatically discovered from the local address of the connection or it can be overridden using this.")
	private String serverName;
	@AttributeDocumentation("The maximum window size of the transmit direction for connection channels, in bytes.")
	private Integer transmitWindowSize;
	@AttributeDocumentation("Worker to use")
	private String worker;
	@AttributeDocumentation("The number of read threads to create for the remoting worker.")
	private Integer workerReadThreads;
	@AttributeDocumentation("The number of core threads for the remoting worker task thread pool.")
	private Integer workerTaskCoreThreads;
	@AttributeDocumentation("The number of milliseconds to keep non-core remoting worker task threads alive.")
	private Integer workerTaskKeepalive;
	@AttributeDocumentation("The maximum number of remoting worker tasks to allow before rejecting.")
	private Integer workerTaskLimit;
	@AttributeDocumentation("The maximum number of threads for the remoting worker task thread pool.")
	private Integer workerTaskMaxThreads;
	@AttributeDocumentation("The number of write threads to create for the remoting worker.")
	private Integer workerWriteThreads;

	public Remoting() {
		super();
		this.key = "remoting";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public RemotingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all HTTPConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(java.util.List<HTTPConnector> value) {
		this.subresources.httpConnectors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPConnector object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @param config
	 *            The HTTPConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey,
			HTTPConnectorConsumer consumer) {
		HTTPConnector<? extends HTTPConnector> child = new HTTPConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnectorSupplier supplier) {
		httpConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<Connector> value) {
		this.subresources.connectors = value;
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * 
	 * @param value
	 *            The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @param config
	 *            The ConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey, ConnectorConsumer consumer) {
		Connector<? extends Connector> child = new Connector<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Connector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connector(ConnectorSupplier supplier) {
		connector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all OutboundConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of OutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnections(java.util.List<OutboundConnection> value) {
		this.subresources.outboundConnections = value;
		return (T) this;
	}

	/**
	 * Add the OutboundConnection object to the list of subresources
	 * 
	 * @param value
	 *            The OutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(OutboundConnection value) {
		this.subresources.outboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a OutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the OutboundConnection resource
	 * @param config
	 *            The OutboundConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(java.lang.String childKey,
			OutboundConnectionConsumer consumer) {
		OutboundConnection<? extends OutboundConnection> child = new OutboundConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		outboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a OutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the OutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(java.lang.String childKey) {
		outboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied OutboundConnection object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(OutboundConnectionSupplier supplier) {
		outboundConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LocalOutboundConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LocalOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnections(
			java.util.List<LocalOutboundConnection> value) {
		this.subresources.localOutboundConnections = value;
		return (T) this;
	}

	/**
	 * Add the LocalOutboundConnection object to the list of subresources
	 * 
	 * @param value
	 *            The LocalOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(LocalOutboundConnection value) {
		this.subresources.localOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LocalOutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LocalOutboundConnection resource
	 * @param config
	 *            The LocalOutboundConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(java.lang.String childKey,
			LocalOutboundConnectionConsumer consumer) {
		LocalOutboundConnection<? extends LocalOutboundConnection> child = new LocalOutboundConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		localOutboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a LocalOutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LocalOutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(java.lang.String childKey) {
		localOutboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LocalOutboundConnection object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(LocalOutboundConnectionSupplier supplier) {
		localOutboundConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteOutboundConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnections(
			java.util.List<RemoteOutboundConnection> value) {
		this.subresources.remoteOutboundConnections = value;
		return (T) this;
	}

	/**
	 * Add the RemoteOutboundConnection object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(RemoteOutboundConnection value) {
		this.subresources.remoteOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteOutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RemoteOutboundConnection resource
	 * @param config
	 *            The RemoteOutboundConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(java.lang.String childKey,
			RemoteOutboundConnectionConsumer consumer) {
		RemoteOutboundConnection<? extends RemoteOutboundConnection> child = new RemoteOutboundConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteOutboundConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteOutboundConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the RemoteOutboundConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(java.lang.String childKey) {
		remoteOutboundConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteOutboundConnection object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(RemoteOutboundConnectionSupplier supplier) {
		remoteOutboundConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T endpointConfiguration(EndpointConfiguration value) {
		this.subresources.endpointConfiguration = value;
		return (T) this;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T endpointConfiguration(EndpointConfigurationConsumer consumer) {
		EndpointConfiguration<? extends EndpointConfiguration> child = new EndpointConfiguration<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.endpointConfiguration = child;
		return (T) this;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T endpointConfiguration() {
		EndpointConfiguration<? extends EndpointConfiguration> child = new EndpointConfiguration<>();
		this.subresources.endpointConfiguration = child;
		return (T) this;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T endpointConfiguration(EndpointConfigurationSupplier supplier) {
		this.subresources.endpointConfiguration = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Remoting
	 */
	public static class RemotingResources {
		/**
		 * The configuration of a HTTP Upgrade based Remoting connector.
		 */
		@ResourceDocumentation("The configuration of a HTTP Upgrade based Remoting connector.")
		@SubresourceInfo("httpConnector")
		private List<HTTPConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * The configuration of a Remoting connector.
		 */
		@ResourceDocumentation("The configuration of a Remoting connector.")
		@SubresourceInfo("connector")
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection.
		 */
		@ResourceDocumentation("Remoting outbound connection.")
		@SubresourceInfo("outboundConnection")
		private List<OutboundConnection> outboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection with an implicit local:// URI scheme.
		 */
		@ResourceDocumentation("Remoting outbound connection with an implicit local:// URI scheme.")
		@SubresourceInfo("localOutboundConnection")
		private List<LocalOutboundConnection> localOutboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection.
		 */
		@ResourceDocumentation("Remoting outbound connection.")
		@SubresourceInfo("remoteOutboundConnection")
		private List<RemoteOutboundConnection> remoteOutboundConnections = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("Endpoint configuration")
		private EndpointConfiguration endpointConfiguration;

		/**
		 * Get the list of HTTPConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPConnector> httpConnectors() {
			return this.httpConnectors;
		}

		public HTTPConnector httpConnector(java.lang.String key) {
			return this.httpConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Connector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		public Connector connector(java.lang.String key) {
			return this.connectors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of OutboundConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<OutboundConnection> outboundConnections() {
			return this.outboundConnections;
		}

		public OutboundConnection outboundConnection(java.lang.String key) {
			return this.outboundConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LocalOutboundConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LocalOutboundConnection> localOutboundConnections() {
			return this.localOutboundConnections;
		}

		public LocalOutboundConnection localOutboundConnection(
				java.lang.String key) {
			return this.localOutboundConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteOutboundConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteOutboundConnection> remoteOutboundConnections() {
			return this.remoteOutboundConnections;
		}

		public RemoteOutboundConnection remoteOutboundConnection(
				java.lang.String key) {
			return this.remoteOutboundConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Endpoint configuration
		 */
		@Subresource
		public EndpointConfiguration endpointConfiguration() {
			return this.endpointConfiguration;
		}
	}

	/**
	 * The authentication realm to use if no authentication CallbackHandler is
	 * specified.
	 */
	@ModelNodeBinding(detypedName = "auth-realm")
	public String authRealm() {
		return this.authRealm;
	}

	/**
	 * The authentication realm to use if no authentication CallbackHandler is
	 * specified.
	 */
	@SuppressWarnings("unchecked")
	public T authRealm(java.lang.String value) {
		Object oldValue = this.authRealm;
		this.authRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication
	 * before closing the connection.
	 */
	@ModelNodeBinding(detypedName = "authentication-retries")
	public Integer authenticationRetries() {
		return this.authenticationRetries;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication
	 * before closing the connection.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationRetries(java.lang.Integer value) {
		Object oldValue = this.authenticationRetries;
		this.authenticationRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationRetries", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The SASL authorization ID. Used as authentication user name to use if no
	 * authentication CallbackHandler is specified and the selected SASL
	 * mechanism demands a user name.
	 */
	@ModelNodeBinding(detypedName = "authorize-id")
	public String authorizeId() {
		return this.authorizeId;
	}

	/**
	 * The SASL authorization ID. Used as authentication user name to use if no
	 * authentication CallbackHandler is specified and the selected SASL
	 * mechanism demands a user name.
	 */
	@SuppressWarnings("unchecked")
	public T authorizeId(java.lang.String value) {
		Object oldValue = this.authorizeId;
		this.authorizeId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authorizeId", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@ModelNodeBinding(detypedName = "buffer-region-size")
	public Integer bufferRegionSize() {
		return this.bufferRegionSize;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@SuppressWarnings("unchecked")
	public T bufferRegionSize(java.lang.Integer value) {
		Object oldValue = this.bufferRegionSize;
		this.bufferRegionSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferRegionSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds. If the
	 * connection is idle in the outbound direction for this amount of time, a
	 * ping message will be sent, which will trigger a corresponding reply
	 * message.
	 */
	@ModelNodeBinding(detypedName = "heartbeat-interval")
	public Integer heartbeatInterval() {
		return this.heartbeatInterval;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds. If the
	 * connection is idle in the outbound direction for this amount of time, a
	 * ping message will be sent, which will trigger a corresponding reply
	 * message.
	 */
	@SuppressWarnings("unchecked")
	public T heartbeatInterval(java.lang.Integer value) {
		Object oldValue = this.heartbeatInterval;
		this.heartbeatInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("heartbeatInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-channels")
	public Integer maxInboundChannels() {
		return this.maxInboundChannels;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundChannels(java.lang.Integer value) {
		Object oldValue = this.maxInboundChannels;
		this.maxInboundChannels = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundChannels", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum inbound message size to be allowed. Messages exceeding this
	 * size will cause an exception to be thrown on the reading side as well as
	 * the writing side.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-message-size")
	public Long maxInboundMessageSize() {
		return this.maxInboundMessageSize;
	}

	/**
	 * The maximum inbound message size to be allowed. Messages exceeding this
	 * size will cause an exception to be thrown on the reading side as well as
	 * the writing side.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundMessageSize(java.lang.Long value) {
		Object oldValue = this.maxInboundMessageSize;
		this.maxInboundMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundMessageSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-messages")
	public Integer maxInboundMessages() {
		return this.maxInboundMessages;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundMessages(java.lang.Integer value) {
		Object oldValue = this.maxInboundMessages;
		this.maxInboundMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundMessages", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-channels")
	public Integer maxOutboundChannels() {
		return this.maxOutboundChannels;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundChannels(java.lang.Integer value) {
		Object oldValue = this.maxOutboundChannels;
		this.maxOutboundChannels = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundChannels", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum outbound message size to send. No messages larger than this
	 * well be transmitted; attempting to do so will cause an exception on the
	 * writing side.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-message-size")
	public Long maxOutboundMessageSize() {
		return this.maxOutboundMessageSize;
	}

	/**
	 * The maximum outbound message size to send. No messages larger than this
	 * well be transmitted; attempting to do so will cause an exception on the
	 * writing side.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundMessageSize(java.lang.Long value) {
		Object oldValue = this.maxOutboundMessageSize;
		this.maxOutboundMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundMessageSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-messages")
	public Integer maxOutboundMessages() {
		return this.maxOutboundMessages;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundMessages(java.lang.Integer value) {
		Object oldValue = this.maxOutboundMessages;
		this.maxOutboundMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundMessages", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a
	 * connection.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer-size")
	public Integer receiveBufferSize() {
		return this.receiveBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a
	 * connection.
	 */
	@SuppressWarnings("unchecked")
	public T receiveBufferSize(java.lang.Integer value) {
		Object oldValue = this.receiveBufferSize;
		this.receiveBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("receiveBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum window size of the receive direction for connection channels,
	 * in bytes.
	 */
	@ModelNodeBinding(detypedName = "receive-window-size")
	public Integer receiveWindowSize() {
		return this.receiveWindowSize;
	}

	/**
	 * The maximum window size of the receive direction for connection channels,
	 * in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T receiveWindowSize(java.lang.Integer value) {
		Object oldValue = this.receiveWindowSize;
		this.receiveWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("receiveWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol
	 * specified it 'remoting', this can be used to override this.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol
	 * specified it 'remoting', this can be used to override this.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(java.lang.String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a
	 * connection.
	 */
	@ModelNodeBinding(detypedName = "send-buffer-size")
	public Integer sendBufferSize() {
		return this.sendBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a
	 * connection.
	 */
	@SuppressWarnings("unchecked")
	public T sendBufferSize(java.lang.Integer value) {
		Object oldValue = this.sendBufferSize;
		this.sendBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sendBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The server side of the connection passes it's name to the client in the
	 * initial greeting, by default the name is automatically discovered from
	 * the local address of the connection or it can be overridden using this.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server side of the connection passes it's name to the client in the
	 * initial greeting, by default the name is automatically discovered from
	 * the local address of the connection or it can be overridden using this.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum window size of the transmit direction for connection
	 * channels, in bytes.
	 */
	@ModelNodeBinding(detypedName = "transmit-window-size")
	public Integer transmitWindowSize() {
		return this.transmitWindowSize;
	}

	/**
	 * The maximum window size of the transmit direction for connection
	 * channels, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T transmitWindowSize(java.lang.Integer value) {
		Object oldValue = this.transmitWindowSize;
		this.transmitWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transmitWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Worker to use
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Worker to use
	 */
	@SuppressWarnings("unchecked")
	public T worker(java.lang.String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of read threads to create for the remoting worker.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-read-threads")
	public Integer workerReadThreads() {
		return this.workerReadThreads;
	}

	/**
	 * The number of read threads to create for the remoting worker.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerReadThreads(java.lang.Integer value) {
		Object oldValue = this.workerReadThreads;
		this.workerReadThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerReadThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of core threads for the remoting worker task thread pool.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-task-core-threads")
	public Integer workerTaskCoreThreads() {
		return this.workerTaskCoreThreads;
	}

	/**
	 * The number of core threads for the remoting worker task thread pool.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerTaskCoreThreads(java.lang.Integer value) {
		Object oldValue = this.workerTaskCoreThreads;
		this.workerTaskCoreThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerTaskCoreThreads", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of milliseconds to keep non-core remoting worker task threads
	 * alive.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-task-keepalive")
	public Integer workerTaskKeepalive() {
		return this.workerTaskKeepalive;
	}

	/**
	 * The number of milliseconds to keep non-core remoting worker task threads
	 * alive.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerTaskKeepalive(java.lang.Integer value) {
		Object oldValue = this.workerTaskKeepalive;
		this.workerTaskKeepalive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerTaskKeepalive", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of remoting worker tasks to allow before rejecting.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-task-limit")
	public Integer workerTaskLimit() {
		return this.workerTaskLimit;
	}

	/**
	 * The maximum number of remoting worker tasks to allow before rejecting.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerTaskLimit(java.lang.Integer value) {
		Object oldValue = this.workerTaskLimit;
		this.workerTaskLimit = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerTaskLimit", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of threads for the remoting worker task thread pool.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-task-max-threads")
	public Integer workerTaskMaxThreads() {
		return this.workerTaskMaxThreads;
	}

	/**
	 * The maximum number of threads for the remoting worker task thread pool.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerTaskMaxThreads(java.lang.Integer value) {
		Object oldValue = this.workerTaskMaxThreads;
		this.workerTaskMaxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerTaskMaxThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of write threads to create for the remoting worker.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "worker-write-threads")
	public Integer workerWriteThreads() {
		return this.workerWriteThreads;
	}

	/**
	 * The number of write threads to create for the remoting worker.
	 * 
	 * @deprecated Use IO subsystem worker configuration
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T workerWriteThreads(java.lang.Integer value) {
		Object oldValue = this.workerWriteThreads;
		this.workerWriteThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("workerWriteThreads", oldValue, value);
		return (T) this;
	}
}