package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.SecurityDomainConsumer;
import org.wildfly.swarm.config.security.SecurityDomainSupplier;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.ElytronTrustManagerConsumer;
import org.wildfly.swarm.config.security.ElytronTrustManagerSupplier;
import org.wildfly.swarm.config.security.ElytronTrustManager;
import org.wildfly.swarm.config.security.ElytronKeyManagerConsumer;
import org.wildfly.swarm.config.security.ElytronKeyManagerSupplier;
import org.wildfly.swarm.config.security.ElytronKeyManager;
import org.wildfly.swarm.config.security.ElytronTrustStoreConsumer;
import org.wildfly.swarm.config.security.ElytronTrustStoreSupplier;
import org.wildfly.swarm.config.security.ElytronTrustStore;
import org.wildfly.swarm.config.security.ElytronKeyStoreConsumer;
import org.wildfly.swarm.config.security.ElytronKeyStoreSupplier;
import org.wildfly.swarm.config.security.ElytronKeyStore;
import org.wildfly.swarm.config.security.ElytronRealmConsumer;
import org.wildfly.swarm.config.security.ElytronRealmSupplier;
import org.wildfly.swarm.config.security.ElytronRealm;
import org.wildfly.swarm.config.security.ClassicVault;
import org.wildfly.swarm.config.security.ClassicVaultConsumer;
import org.wildfly.swarm.config.security.ClassicVaultSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the security subsystem.
 */
@Address("/subsystem=security")
@ResourceType("subsystem")
@Implicit
public class Security<T extends Security<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SecurityResources subresources = new SecurityResources();
	@AttributeDocumentation("Sets the copy mode of subjects done by the security managers to be deep copies that makes copies of the subject principals and credentials if they are cloneable. It should be set to true if subject include mutable content that can be corrupted when multiple threads have the same identity and cache flushes/logout clearing the subject in one thread results in subject references affecting other threads.")
	private Boolean deepCopySubjectMode;
	@AttributeDocumentation("Indicates if this subsystem should be in charge of initializing JACC related services.")
	private Boolean initializeJacc;

	public Security() {
		super();
		this.key = "security";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SecurityResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all SecurityDomain objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecurityDomain objects.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomains(java.util.List<SecurityDomain> value) {
		this.subresources.securityDomains = value;
		return (T) this;
	}

	/**
	 * Add the SecurityDomain object to the list of subresources
	 * 
	 * @param value
	 *            The SecurityDomain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(SecurityDomain value) {
		this.subresources.securityDomains.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityDomain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityDomain resource
	 * @param config
	 *            The SecurityDomainConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String childKey,
			SecurityDomainConsumer consumer) {
		SecurityDomain<? extends SecurityDomain> child = new SecurityDomain<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		securityDomain(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecurityDomain object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecurityDomain resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String childKey) {
		securityDomain(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecurityDomain object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(SecurityDomainSupplier supplier) {
		securityDomain(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ElytronTrustManager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ElytronTrustManager objects.
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustManagers(java.util.List<ElytronTrustManager> value) {
		this.subresources.elytronTrustManagers = value;
		return (T) this;
	}

	/**
	 * Add the ElytronTrustManager object to the list of subresources
	 * 
	 * @param value
	 *            The ElytronTrustManager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustManager(ElytronTrustManager value) {
		this.subresources.elytronTrustManagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronTrustManager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronTrustManager resource
	 * @param config
	 *            The ElytronTrustManagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustManager(java.lang.String childKey,
			ElytronTrustManagerConsumer consumer) {
		ElytronTrustManager<? extends ElytronTrustManager> child = new ElytronTrustManager<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		elytronTrustManager(child);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronTrustManager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronTrustManager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustManager(java.lang.String childKey) {
		elytronTrustManager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ElytronTrustManager object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustManager(ElytronTrustManagerSupplier supplier) {
		elytronTrustManager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ElytronKeyManager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ElytronKeyManager objects.
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyManagers(java.util.List<ElytronKeyManager> value) {
		this.subresources.elytronKeyManagers = value;
		return (T) this;
	}

	/**
	 * Add the ElytronKeyManager object to the list of subresources
	 * 
	 * @param value
	 *            The ElytronKeyManager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyManager(ElytronKeyManager value) {
		this.subresources.elytronKeyManagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronKeyManager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronKeyManager resource
	 * @param config
	 *            The ElytronKeyManagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyManager(java.lang.String childKey,
			ElytronKeyManagerConsumer consumer) {
		ElytronKeyManager<? extends ElytronKeyManager> child = new ElytronKeyManager<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		elytronKeyManager(child);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronKeyManager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronKeyManager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyManager(java.lang.String childKey) {
		elytronKeyManager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ElytronKeyManager object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyManager(ElytronKeyManagerSupplier supplier) {
		elytronKeyManager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ElytronTrustStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ElytronTrustStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustStores(java.util.List<ElytronTrustStore> value) {
		this.subresources.elytronTrustStores = value;
		return (T) this;
	}

	/**
	 * Add the ElytronTrustStore object to the list of subresources
	 * 
	 * @param value
	 *            The ElytronTrustStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustStore(ElytronTrustStore value) {
		this.subresources.elytronTrustStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronTrustStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronTrustStore resource
	 * @param config
	 *            The ElytronTrustStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustStore(java.lang.String childKey,
			ElytronTrustStoreConsumer consumer) {
		ElytronTrustStore<? extends ElytronTrustStore> child = new ElytronTrustStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		elytronTrustStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronTrustStore object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ElytronTrustStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustStore(java.lang.String childKey) {
		elytronTrustStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ElytronTrustStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T elytronTrustStore(ElytronTrustStoreSupplier supplier) {
		elytronTrustStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ElytronKeyStore objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ElytronKeyStore objects.
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyStores(java.util.List<ElytronKeyStore> value) {
		this.subresources.elytronKeyStores = value;
		return (T) this;
	}

	/**
	 * Add the ElytronKeyStore object to the list of subresources
	 * 
	 * @param value
	 *            The ElytronKeyStore to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyStore(ElytronKeyStore value) {
		this.subresources.elytronKeyStores.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronKeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ElytronKeyStore resource
	 * @param config
	 *            The ElytronKeyStoreConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyStore(java.lang.String childKey,
			ElytronKeyStoreConsumer consumer) {
		ElytronKeyStore<? extends ElytronKeyStore> child = new ElytronKeyStore<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		elytronKeyStore(child);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronKeyStore object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ElytronKeyStore resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyStore(java.lang.String childKey) {
		elytronKeyStore(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ElytronKeyStore object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T elytronKeyStore(ElytronKeyStoreSupplier supplier) {
		elytronKeyStore(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ElytronRealm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ElytronRealm objects.
	 */
	@SuppressWarnings("unchecked")
	public T elytronRealms(java.util.List<ElytronRealm> value) {
		this.subresources.elytronRealms = value;
		return (T) this;
	}

	/**
	 * Add the ElytronRealm object to the list of subresources
	 * 
	 * @param value
	 *            The ElytronRealm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronRealm(ElytronRealm value) {
		this.subresources.elytronRealms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ElytronRealm resource
	 * @param config
	 *            The ElytronRealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronRealm(java.lang.String childKey,
			ElytronRealmConsumer consumer) {
		ElytronRealm<? extends ElytronRealm> child = new ElytronRealm<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		elytronRealm(child);
		return (T) this;
	}

	/**
	 * Create and configure a ElytronRealm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ElytronRealm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T elytronRealm(java.lang.String childKey) {
		elytronRealm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ElytronRealm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T elytronRealm(ElytronRealmSupplier supplier) {
		elytronRealm(supplier.get());
		return (T) this;
	}

	/**
	 * Security Vault for attributes.
	 */
	@SuppressWarnings("unchecked")
	public T classicVault(ClassicVault value) {
		this.subresources.classicVault = value;
		return (T) this;
	}

	/**
	 * Security Vault for attributes.
	 */
	@SuppressWarnings("unchecked")
	public T classicVault(ClassicVaultConsumer consumer) {
		ClassicVault<? extends ClassicVault> child = new ClassicVault<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicVault = child;
		return (T) this;
	}

	/**
	 * Security Vault for attributes.
	 */
	@SuppressWarnings("unchecked")
	public T classicVault() {
		ClassicVault<? extends ClassicVault> child = new ClassicVault<>();
		this.subresources.classicVault = child;
		return (T) this;
	}

	/**
	 * Security Vault for attributes.
	 */
	@SuppressWarnings("unchecked")
	public T classicVault(ClassicVaultSupplier supplier) {
		this.subresources.classicVault = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Security
	 */
	public static class SecurityResources {
		/**
		 * Configures a security domain. Authentication, authorization, ACL,
		 * mapping, auditing and identity trust are configured here.
		 */
		@ResourceDocumentation("Configures a security domain. Authentication, authorization, ACL, mapping, auditing and identity trust are configured here.")
		@SubresourceInfo("securityDomain")
		private List<SecurityDomain> securityDomains = new java.util.ArrayList<>();
		/**
		 * The configuration of an Elytron-compatible trust manager that is
		 * exported from a legacy JSSE domain.
		 */
		@ResourceDocumentation("The configuration of an Elytron-compatible trust manager that is exported from a legacy JSSE domain.")
		@SubresourceInfo("elytronTrustManager")
		private List<ElytronTrustManager> elytronTrustManagers = new java.util.ArrayList<>();
		/**
		 * The configuration of an Elytron-compatible key manager that is
		 * exported from a legacy JSSE domain.
		 */
		@ResourceDocumentation("The configuration of an Elytron-compatible key manager that is exported from a legacy JSSE domain.")
		@SubresourceInfo("elytronKeyManager")
		private List<ElytronKeyManager> elytronKeyManagers = new java.util.ArrayList<>();
		/**
		 * The configuration of an Elytron-compatible trust store that is
		 * exported from a legacy JSSE domain.
		 */
		@ResourceDocumentation("The configuration of an Elytron-compatible trust store that is exported from a legacy JSSE domain.")
		@SubresourceInfo("elytronTrustStore")
		private List<ElytronTrustStore> elytronTrustStores = new java.util.ArrayList<>();
		/**
		 * The configuration of an Elytron-compatible key store that is exported
		 * from a legacy JSSE domain.
		 */
		@ResourceDocumentation("The configuration of an Elytron-compatible key store that is exported from a legacy JSSE domain.")
		@SubresourceInfo("elytronKeyStore")
		private List<ElytronKeyStore> elytronKeyStores = new java.util.ArrayList<>();
		/**
		 * The configuration of an Elytron-compatible realm that delegates
		 * authentication decisions to a legacy security domain.
		 */
		@ResourceDocumentation("The configuration of an Elytron-compatible realm that delegates authentication decisions to a legacy security domain.")
		@SubresourceInfo("elytronRealm")
		private List<ElytronRealm> elytronRealms = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("Security Vault for attributes.")
		private ClassicVault classicVault;

		/**
		 * Get the list of SecurityDomain resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecurityDomain> securityDomains() {
			return this.securityDomains;
		}

		public SecurityDomain securityDomain(java.lang.String key) {
			return this.securityDomains.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ElytronTrustManager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ElytronTrustManager> elytronTrustManagers() {
			return this.elytronTrustManagers;
		}

		public ElytronTrustManager elytronTrustManager(java.lang.String key) {
			return this.elytronTrustManagers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ElytronKeyManager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ElytronKeyManager> elytronKeyManagers() {
			return this.elytronKeyManagers;
		}

		public ElytronKeyManager elytronKeyManager(java.lang.String key) {
			return this.elytronKeyManagers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ElytronTrustStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ElytronTrustStore> elytronTrustStores() {
			return this.elytronTrustStores;
		}

		public ElytronTrustStore elytronTrustStore(java.lang.String key) {
			return this.elytronTrustStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ElytronKeyStore resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ElytronKeyStore> elytronKeyStores() {
			return this.elytronKeyStores;
		}

		public ElytronKeyStore elytronKeyStore(java.lang.String key) {
			return this.elytronKeyStores.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ElytronRealm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ElytronRealm> elytronRealms() {
			return this.elytronRealms;
		}

		public ElytronRealm elytronRealm(java.lang.String key) {
			return this.elytronRealms.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Security Vault for attributes.
		 */
		@Subresource
		public ClassicVault classicVault() {
			return this.classicVault;
		}
	}

	/**
	 * Sets the copy mode of subjects done by the security managers to be deep
	 * copies that makes copies of the subject principals and credentials if
	 * they are cloneable. It should be set to true if subject include mutable
	 * content that can be corrupted when multiple threads have the same
	 * identity and cache flushes/logout clearing the subject in one thread
	 * results in subject references affecting other threads.
	 */
	@ModelNodeBinding(detypedName = "deep-copy-subject-mode")
	public Boolean deepCopySubjectMode() {
		return this.deepCopySubjectMode;
	}

	/**
	 * Sets the copy mode of subjects done by the security managers to be deep
	 * copies that makes copies of the subject principals and credentials if
	 * they are cloneable. It should be set to true if subject include mutable
	 * content that can be corrupted when multiple threads have the same
	 * identity and cache flushes/logout clearing the subject in one thread
	 * results in subject references affecting other threads.
	 */
	@SuppressWarnings("unchecked")
	public T deepCopySubjectMode(java.lang.Boolean value) {
		Object oldValue = this.deepCopySubjectMode;
		this.deepCopySubjectMode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deepCopySubjectMode", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates if this subsystem should be in charge of initializing JACC
	 * related services.
	 */
	@ModelNodeBinding(detypedName = "initialize-jacc")
	public Boolean initializeJacc() {
		return this.initializeJacc;
	}

	/**
	 * Indicates if this subsystem should be in charge of initializing JACC
	 * related services.
	 */
	@SuppressWarnings("unchecked")
	public T initializeJacc(java.lang.Boolean value) {
		Object oldValue = this.initializeJacc;
		this.initializeJacc = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initializeJacc", oldValue, value);
		return (T) this;
	}
}