package org.wildfly.swarm.config.deployment.scanner;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the deployment scanner subsystem
 */
@Address("/subsystem=deployment-scanner/scanner=*")
@ResourceType("scanner")
public class Scanner<T extends Scanner<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Allows the automatic deployment of exploded content without requiring a .dodeploy marker file. Recommended for only basic development scenarios to prevent exploded application deployment from occurring during changes by the developer or operating system.")
	private Boolean autoDeployExploded;
	@AttributeDocumentation("Allows automatic deployment of XML content without requiring a .dodeploy marker file.")
	private Boolean autoDeployXml;
	@AttributeDocumentation("Allows automatic deployment of zipped content without requiring a .dodeploy marker file.")
	private Boolean autoDeployZipped;
	@AttributeDocumentation("The time value in seconds for the deployment scanner to allow a deployment attempt before being cancelled.")
	private Long deploymentTimeout;
	@AttributeDocumentation("The actual filesystem path to be scanned. Treated as an absolute path, unless the 'relative-to' attribute is specified, in which case the value is treated as relative to that path.")
	private String path;
	@AttributeDocumentation("Reference to a filesystem path defined in the \"paths\" section of the server configuration.")
	private String relativeTo;
	@AttributeDocumentation("Flag indicating whether a runtime failure of a deployment causes a rollback of the deployment as well as all other (maybe unrelated) deployments as part of the scan operation.")
	private Boolean runtimeFailureCausesRollback;
	@AttributeDocumentation("Flag indicating if all scanning (including initial scanning at startup) is enabled.")
	private Boolean scanEnabled;
	@AttributeDocumentation("Periodic interval, in milliseconds, at which the repository should be scanned for changes. A value of less than 1 indicates the repository should only be scanned at initial startup.")
	private Integer scanInterval;

	public Scanner(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Allows the automatic deployment of exploded content without requiring a
	 * .dodeploy marker file. Recommended for only basic development scenarios
	 * to prevent exploded application deployment from occurring during changes
	 * by the developer or operating system.
	 */
	@ModelNodeBinding(detypedName = "auto-deploy-exploded")
	public Boolean autoDeployExploded() {
		return this.autoDeployExploded;
	}

	/**
	 * Allows the automatic deployment of exploded content without requiring a
	 * .dodeploy marker file. Recommended for only basic development scenarios
	 * to prevent exploded application deployment from occurring during changes
	 * by the developer or operating system.
	 */
	@SuppressWarnings("unchecked")
	public T autoDeployExploded(java.lang.Boolean value) {
		Object oldValue = this.autoDeployExploded;
		this.autoDeployExploded = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoDeployExploded", oldValue, value);
		return (T) this;
	}

	/**
	 * Allows automatic deployment of XML content without requiring a .dodeploy
	 * marker file.
	 */
	@ModelNodeBinding(detypedName = "auto-deploy-xml")
	public Boolean autoDeployXml() {
		return this.autoDeployXml;
	}

	/**
	 * Allows automatic deployment of XML content without requiring a .dodeploy
	 * marker file.
	 */
	@SuppressWarnings("unchecked")
	public T autoDeployXml(java.lang.Boolean value) {
		Object oldValue = this.autoDeployXml;
		this.autoDeployXml = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoDeployXml", oldValue, value);
		return (T) this;
	}

	/**
	 * Allows automatic deployment of zipped content without requiring a
	 * .dodeploy marker file.
	 */
	@ModelNodeBinding(detypedName = "auto-deploy-zipped")
	public Boolean autoDeployZipped() {
		return this.autoDeployZipped;
	}

	/**
	 * Allows automatic deployment of zipped content without requiring a
	 * .dodeploy marker file.
	 */
	@SuppressWarnings("unchecked")
	public T autoDeployZipped(java.lang.Boolean value) {
		Object oldValue = this.autoDeployZipped;
		this.autoDeployZipped = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoDeployZipped", oldValue, value);
		return (T) this;
	}

	/**
	 * The time value in seconds for the deployment scanner to allow a
	 * deployment attempt before being cancelled.
	 */
	@ModelNodeBinding(detypedName = "deployment-timeout")
	public Long deploymentTimeout() {
		return this.deploymentTimeout;
	}

	/**
	 * The time value in seconds for the deployment scanner to allow a
	 * deployment attempt before being cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T deploymentTimeout(java.lang.Long value) {
		Object oldValue = this.deploymentTimeout;
		this.deploymentTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deploymentTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The actual filesystem path to be scanned. Treated as an absolute path,
	 * unless the 'relative-to' attribute is specified, in which case the value
	 * is treated as relative to that path.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The actual filesystem path to be scanned. Treated as an absolute path,
	 * unless the 'relative-to' attribute is specified, in which case the value
	 * is treated as relative to that path.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to a filesystem path defined in the "paths" section of the
	 * server configuration.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * Reference to a filesystem path defined in the "paths" section of the
	 * server configuration.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * Flag indicating whether a runtime failure of a deployment causes a
	 * rollback of the deployment as well as all other (maybe unrelated)
	 * deployments as part of the scan operation.
	 */
	@ModelNodeBinding(detypedName = "runtime-failure-causes-rollback")
	public Boolean runtimeFailureCausesRollback() {
		return this.runtimeFailureCausesRollback;
	}

	/**
	 * Flag indicating whether a runtime failure of a deployment causes a
	 * rollback of the deployment as well as all other (maybe unrelated)
	 * deployments as part of the scan operation.
	 */
	@SuppressWarnings("unchecked")
	public T runtimeFailureCausesRollback(java.lang.Boolean value) {
		Object oldValue = this.runtimeFailureCausesRollback;
		this.runtimeFailureCausesRollback = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("runtimeFailureCausesRollback",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Flag indicating if all scanning (including initial scanning at startup)
	 * is enabled.
	 */
	@ModelNodeBinding(detypedName = "scan-enabled")
	public Boolean scanEnabled() {
		return this.scanEnabled;
	}

	/**
	 * Flag indicating if all scanning (including initial scanning at startup)
	 * is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T scanEnabled(java.lang.Boolean value) {
		Object oldValue = this.scanEnabled;
		this.scanEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scanEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Periodic interval, in milliseconds, at which the repository should be
	 * scanned for changes. A value of less than 1 indicates the repository
	 * should only be scanned at initial startup.
	 */
	@ModelNodeBinding(detypedName = "scan-interval")
	public Integer scanInterval() {
		return this.scanInterval;
	}

	/**
	 * Periodic interval, in milliseconds, at which the repository should be
	 * scanned for changes. A value of less than 1 indicates the repository
	 * should only be scanned at initial startup.
	 */
	@SuppressWarnings("unchecked")
	public T scanInterval(java.lang.Integer value) {
		Object oldValue = this.scanInterval;
		this.scanInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scanInterval", oldValue, value);
		return (T) this;
	}
}