package org.wildfly.swarm.config.deployment.scanner;

import org.wildfly.swarm.config.deployment.scanner.Scanner;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ScannerConsumer<T extends Scanner<T>> {

	/**
	 * Configure a pre-constructed instance of Scanner resource
	 * 
	 * @parameter Instance of Scanner to configure
	 * @return nothing
	 */
	void accept(T value);

	default ScannerConsumer<T> andThen(ScannerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}