package org.wildfly.swarm.config.discovery;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An aggregate discovery provider definition
 */
@Address("/subsystem=discovery/aggregate-provider=*")
@ResourceType("aggregate-provider")
public class AggregateProvider<T extends AggregateProvider<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The list of providers that are aggregated by this provider")
	private List<String> providers;

	public AggregateProvider(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The list of providers that are aggregated by this provider
	 */
	@ModelNodeBinding(detypedName = "providers")
	public List<String> providers() {
		return this.providers;
	}

	/**
	 * The list of providers that are aggregated by this provider
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.util.List<String> value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of providers that are aggregated by this provider
	 */
	@SuppressWarnings("unchecked")
	public T provider(String value) {
		if (this.providers == null) {
			this.providers = new java.util.ArrayList<>();
		}
		this.providers.add(value);
		return (T) this;
	}

	/**
	 * The list of providers that are aggregated by this provider
	 */
	@SuppressWarnings("unchecked")
	public T providers(String... args) {
		providers(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}