package org.wildfly.swarm.config.discovery;

import org.wildfly.swarm.config.discovery.AggregateProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateProviderConsumer<T extends AggregateProvider<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateProvider resource
	 * 
	 * @parameter Instance of AggregateProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateProviderConsumer<T> andThen(
			AggregateProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}